/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangValidationException;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;

public class APEXLangArrayDataType
extends APEXLangDataType {
    private APEXLangDataType[] arrayData;
    private String multivalueDelimiter;

    public APEXLangArrayDataType(APEXLangDataType[] data, String multivalueDelimiter) {
        super("");
        this.arrayData = data;
        this.multivalueDelimiter = multivalueDelimiter;
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        List preparedData = Arrays.stream(this.arrayData).map(element -> element.toString()).collect(Collectors.toList());
        if ("\n".equals(this.multivalueDelimiter)) {
            return Transpiler.replaceAllSafely(template, bindVariable, "wwv_flow_string.join(wwv_flow_t_varchar2(" + preparedData.stream().map(line -> "'" + line.replaceAll("'", "''") + "'").collect(Collectors.joining(",\n")) + "))");
        }
        return Transpiler.replaceAllSafely(template, bindVariable, "'" + String.join((CharSequence)this.multivalueDelimiter, preparedData).replaceAll("'", "''") + "'");
    }

    @Override
    protected void validateImpl(Property property, PropertyType propertyType) throws APEXLangValidationException {
        for (APEXLangDataType dt : this.arrayData) {
            dt.validate(property, propertyType);
        }
    }

    public APEXLangDataType[] getData() {
        return this.arrayData;
    }
}

