/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.oci;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.core.util.Pair;

public class OCIRequest {
    private String _method;
    private String _host;
    private String _target;
    private String _body;
    private String _contentType;
    private File _bodyFile;
    private InputStream _inputStream;
    private List<Pair<String, String>> _headers;

    public OCIRequest(String method, String host, String target, String body, String contentType, File bodyFile, InputStream inputStream, List<Pair<String, String>> headers) {
        this._method = method;
        this._host = host;
        this._target = target;
        this._body = body;
        this._contentType = contentType;
        this._bodyFile = bodyFile;
        this._inputStream = inputStream;
        this._headers = headers;
    }

    public String getMethod() {
        return this._method;
    }

    public String getHost() {
        return this._host;
    }

    public String getTarget() {
        return this._target;
    }

    public String getBody() {
        return this._body;
    }

    public String getContentType() {
        return this._contentType;
    }

    public File getBodyFile() {
        return this._bodyFile;
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public void addHeader(String name, String value) {
        if (null == this._headers) {
            this._headers = new ArrayList<Pair<String, String>>();
        }
        this._headers.add((Pair<String, String>)Pair.of((Object)name, (Object)value));
    }

    public List<Pair<String, String>> getHeaders() {
        return this._headers;
    }

    public boolean hasBody() {
        return this._body != null || this._bodyFile != null;
    }

    public String getFinalPath() {
        return this._target == null ? null : this._target.substring(this._target.lastIndexOf("/") + 1, this._target.lastIndexOf("?") == -1 ? this._target.length() : this._target.lastIndexOf("?"));
    }

    public static class Builder {
        private String _method;
        private String _target;
        private String _body;
        private String _host;
        private String _contentType = "application/octet-stream";
        private File _bodyFile;
        private InputStream _inputStream;
        private List<Pair<String, String>> _headers;

        public Builder method(String method) {
            this._method = method;
            return this;
        }

        public Builder host(String host) {
            this._host = host;
            return this;
        }

        public Builder target(String target) {
            this._target = target;
            return this;
        }

        public Builder body(String body) {
            this._body = body;
            return this;
        }

        public Builder contentType(String contentType) {
            this._contentType = contentType;
            return this;
        }

        public Builder bodyFile(File bodyFile) {
            this._bodyFile = bodyFile;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this._inputStream = inputStream;
            return this;
        }

        public Builder header(String name, String value) {
            if (null == this._headers) {
                this._headers = new ArrayList<Pair<String, String>>();
            }
            this._headers.add((Pair<String, String>)Pair.of((Object)name, (Object)value));
            return this;
        }

        public OCIRequest build() {
            return new OCIRequest(this._method, this._host, this._target, this._body, this._contentType, this._bodyFile, this._inputStream, this._headers);
        }
    }
}

