/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http.auth.basic;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import oracle.dbtools.core.util.Pair;
import oracle.dbtools.http.AbstractJsonHandler;
import oracle.dbtools.http.AbstractResponseHandler;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.auth.Authentication;
import oracle.dbtools.http.auth.AuthenticationFailedException;
import oracle.dbtools.http.logger.Logger;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.StatusLine;

public class BasicAuthenticationHandler
extends AbstractResponseHandler<Authentication> {
    private static final Logger LOGGER = Logger.of(BasicAuthenticationHandler.class);
    private static final String RESPONSE_ERROR_DESCRIPTION = "error_description";
    private static final String RESPONSE_ERROR = "error";

    private static Pair<String, String> parseErrorString(ClassicHttpResponse resp) {
        String error = null;
        String message = null;
        try (Reader r = Client.createReader(resp);){
            JSON mapper = AbstractJsonHandler.getObjectMapper();
            TreeNode node = mapper.treeFrom((Object)r);
            error = ((JrsValue)node.path(RESPONSE_ERROR)).asText();
            message = ((JrsValue)node.path(RESPONSE_ERROR_DESCRIPTION)).asText();
        }
        catch (IOException e) {
            LOGGER.error(e);
        }
        LOGGER.warning(MessageFormat.format("{0}: {1}", error, message));
        return Pair.of((Object)error, (Object)message);
    }

    private Authentication parseAuthentication(ClassicHttpResponse resp) throws IOException {
        Authentication auth = new Authentication();
        try (Reader r = Client.createReader(resp);){
            JSON mapper = AbstractJsonHandler.getObjectMapper();
            TreeNode node = mapper.treeFrom((Object)r);
            auth.setToken(((JrsValue)node.path("access_token")).asText());
            auth.setTokenType(((JrsValue)node.path("token_type")).asText());
            auth.setRefreshToken(((JrsValue)node.path("refresh_token")).asText());
        }
        return auth;
    }

    @Override
    protected Authentication handleSuccess(ClassicHttpResponse resp) throws IOException {
        return this.parseAuthentication(resp);
    }

    @Override
    protected IOException createInternalServerError(String errorMessage, String errorText, String errorTextType) {
        return new AuthenticationFailedException(errorMessage, errorText, errorTextType);
    }

    @Override
    protected Authentication handleError(ClassicHttpResponse resp) throws IOException {
        int code = resp.getCode();
        switch (code) {
            case 400: {
                Pair<String, String> error = BasicAuthenticationHandler.parseErrorString(resp);
                if (error == null) break;
                throw new AuthenticationFailedException((String)error.first(), (String)error.second());
            }
        }
        throw new IOException(new StatusLine((HttpResponse)resp).toString());
    }
}

