/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.net.URI;
import java.util.Arrays;
import java.util.Objects;

public final class SessionInfo {
    private final String m_name;
    private final URI m_root;
    private final String m_user;
    private final char[] m_pwd;
    private final URI m_serviceRoot;
    private final SftpInfo m_sftpInfo;
    private final OssInfo m_ossInfo;

    public SessionInfo(String name, URI root, URI serviceRoot, String username, char[] pwd) {
        this(name, root, serviceRoot, username, pwd, null);
    }

    public SessionInfo(String name, URI root, URI serviceRoot, String username, char[] pwd, SftpInfo sftpInfo) {
        this(name, root, serviceRoot, username, pwd, sftpInfo, null);
    }

    public SessionInfo(String name, URI root, URI serviceRoot, String username, char[] pwd, SftpInfo sftpInfo, OssInfo ossInfo) {
        this.m_name = name;
        this.m_root = root;
        this.m_serviceRoot = serviceRoot;
        this.m_user = username;
        this.m_pwd = pwd;
        this.m_sftpInfo = sftpInfo;
        this.m_ossInfo = ossInfo;
    }

    public String getName() {
        return this.m_name;
    }

    public URI getServerRoot() {
        return this.m_root;
    }

    public URI getServiceRoot() {
        return this.m_serviceRoot;
    }

    public String getUsername() {
        return this.m_user;
    }

    public char[] getPassword() {
        return this.m_pwd;
    }

    public SftpInfo getSftpInfo() {
        return this.m_sftpInfo;
    }

    public OssInfo getOssInfo() {
        return this.m_ossInfo;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SessionInfo && Objects.equals(this.m_name, ((SessionInfo)obj).m_name) && Objects.equals(this.m_root, ((SessionInfo)obj).m_root) && Objects.equals(this.m_serviceRoot, ((SessionInfo)obj).m_serviceRoot) && Objects.equals(this.m_user, ((SessionInfo)obj).m_user) && Objects.equals(this.m_pwd, ((SessionInfo)obj).m_pwd) && Objects.equals(this.m_sftpInfo, ((SessionInfo)obj).m_sftpInfo) && Objects.equals(this.m_ossInfo, ((SessionInfo)obj).m_ossInfo);
    }

    public String toString() {
        return this.m_name + "#" + String.valueOf(this.m_root) + "#" + String.valueOf(this.m_serviceRoot) + "#" + this.m_user + "#" + String.valueOf(this.m_sftpInfo) != null ? this.m_sftpInfo.toString() : (String.valueOf(this.m_ossInfo) != null ? this.m_ossInfo.toString() : "");
    }

    public static final class SftpInfo {
        public static final int UNSPECIFIED_PORT_VALUE = -1;
        private String m_ftpUser;
        private char[] m_ftpPass;
        private String m_ftpHost;
        private int m_ftpPort;

        public SftpInfo(String ftpUser, char[] ftpPass, String ftpHost, int ftpPort) {
            this.m_ftpUser = ftpUser;
            this.m_ftpPass = ftpPass;
            this.m_ftpHost = ftpHost;
            this.m_ftpPort = ftpPort;
        }

        public String getSftpUser() {
            return this.m_ftpUser;
        }

        public char[] getSftpPass() {
            return this.m_ftpPass;
        }

        public String getSftpHost() {
            return this.m_ftpHost;
        }

        public int getSftpPort() {
            return this.m_ftpPort;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SftpInfo && Objects.equals(this.m_ftpHost, ((SftpInfo)obj).m_ftpHost) && this.m_ftpPort == ((SftpInfo)obj).m_ftpPort && Objects.equals(this.m_ftpUser, ((SftpInfo)obj).m_ftpUser) && Objects.equals(this.m_ftpPass, ((SftpInfo)obj).m_ftpPass);
        }

        public String toString() {
            return this.m_ftpUser + "#" + this.m_ftpHost + "#" + this.m_ftpPort;
        }
    }

    public static final class OssInfo {
        private boolean m_ossEnabled;
        private String m_ossServiceName;
        private String m_ossIdentityDomain;
        private String m_ossUserName;
        private char[] m_ossPassword;
        private String m_ossServiceUrl;

        public OssInfo(boolean ossEnabled, String ossServiceName, String ossIdentityDomain, String ossUserName, char[] ossPassword, String ossServiceUrl) {
            this.m_ossEnabled = ossEnabled;
            this.m_ossServiceName = ossServiceName;
            this.m_ossIdentityDomain = ossIdentityDomain;
            this.m_ossUserName = ossUserName;
            if (ossPassword != null) {
                this.m_ossPassword = Arrays.copyOf(ossPassword, ossPassword.length);
            }
            this.m_ossServiceUrl = ossServiceUrl;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean isOssEnabled() {
            return this.m_ossEnabled;
        }

        public void setOssEnabled(boolean ossEnabled) {
            this.m_ossEnabled = ossEnabled;
        }

        public String getOssServiceName() {
            return this.m_ossServiceName;
        }

        public void setOssServiceName(String ossServiceName) {
            this.m_ossServiceName = ossServiceName;
        }

        public String getOssIdentityDomain() {
            return this.m_ossIdentityDomain;
        }

        public void setOssIdentityDomain(String ossIdentityDomain) {
            this.m_ossIdentityDomain = ossIdentityDomain;
        }

        public String getOssUserName() {
            return this.m_ossUserName;
        }

        public void setOssUserName(String ossUserName) {
            this.m_ossUserName = ossUserName;
        }

        public char[] getOssPassword() {
            return this.m_ossPassword;
        }

        public void setOssPassword(char[] ossPassword) {
            this.m_ossPassword = ossPassword;
        }

        public String getOssServiceUrl() {
            return this.m_ossServiceUrl;
        }

        public void setOssServiceUrl(String m_ossServiceUrl) {
            this.m_ossServiceUrl = m_ossServiceUrl;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof OssInfo && this.m_ossEnabled == ((OssInfo)obj).m_ossEnabled && Objects.equals(this.m_ossServiceName, ((OssInfo)obj).m_ossServiceName) && Objects.equals(this.m_ossIdentityDomain, ((OssInfo)obj).m_ossIdentityDomain) && Objects.equals(this.m_ossUserName, ((OssInfo)obj).m_ossUserName) && Objects.equals(this.m_ossPassword, ((OssInfo)obj).m_ossPassword) && Objects.equals(this.m_ossServiceUrl, ((OssInfo)obj).m_ossServiceUrl);
        }

        public String toString() {
            return this.m_ossIdentityDomain + "#" + this.m_ossUserName + "#" + this.m_ossServiceName + "@" + this.m_ossServiceUrl;
        }
    }
}

