Rem
Rem $Header: dbgendev/src/langdata/plsql/errors/errors_pkg.pks /main/18 2025/08/13 01:29:21 jiangnhu Exp $
Rem
Rem errors_pkg.pls
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      errors_pkg.pks - Package Specification of errors_pkg.
Rem
Rem    DESCRIPTION
Rem      Contains the specifications of the package with prcoedures to manage 
Rem      the errors and exceptions in the PL/SQL packages of Lang-Data.
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/errors/errors_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jiangnhu    07/29/25 - Add c_invalid_llm_response
Rem    deveverm    07/15/25 - DBAI-1050: added get_message
Rem    dadoshi     07/09/25 - Remove c_index_still_exists_timeout exception
Rem    deveverm    07/09/25 - DBAI-976: replaced c_embedding_model_not_found
Rem                           with c_resource_already_exists
Rem    dadoshi     07/07/25 - JIRA_DBAI1022: Remove
Rem                           c_incompatible_database_version,
Rem                           c_migration_needed, and
Rem                           c_schema_version_not_setup exceptions
Rem    fgurrola    06/27/25 - DBAI-776: Added error code for unsupported
Rem                           name entity error.
Rem    deveverm    06/02/25 - DBAI-794: added error codes for OCI related
Rem                           errors
Rem    saloshah	   05/26/25 - DBAI-746: Add row lock timeout error code
Rem    deveverm    05/16/25 - added error for failed job creation
Rem    pryarla     05/15/25 - DBAI-737: Add invalid profile error for llm
Rem    deveverm    04/17/25 - DBAI-735: added error codes for OCI embedding
Rem                           generation
Rem    jiangnhu    04/01/25 - Add c_enumeration_limit_exceeded
Rem    jiangnhu    02/24/25 - Add c_index_still_exists_timeout
Rem    jiangnhu    02/14/25 - DBAI-575: Remove c_unknown_exception_code
Rem    dadoshi     10/25/24 - Add new errors
Rem    pryarla     10/16/24 - Created
Rem

create or replace package lang_data_errors_pkg is
    -- Error Codes
    c_unauthorized_code             constant number := -20000;
    c_invalid_parameters_code       constant number := -20001;
    c_max_text_length_exceeded      constant number := -20002;
    c_resource_not_found            CONSTANT NUMBER := -20003;
    c_invalid_match_document        CONSTANT NUMBER := -20004;
    c_resource_already_exists       CONSTANT NUMBER := -20005;
    c_description_invalid_deletion  CONSTANT NUMBER := -20006;
    c_invalid_update                CONSTANT NUMBER := -20007;
    c_enumeration_limit_exceeded    CONSTANT NUMBER := -20008;
    c_ACL_not_configured            CONSTANT NUMBER := -20009;
    c_invalid_dbms_cloud_ai_profile CONSTANT NUMBER := -20010;
    c_row_lock_timeout              CONSTANT NUMBER := -20011;
    c_OCI_credential_not_set        CONSTANT NUMBER := -20012;
    c_OCI_GenAI_endpoint_not_set    CONSTANT NUMBER := -20013;
    c_OCI_compartment_not_set       CONSTANT NUMBER := -20014;
    c_OCI_region_not_set            CONSTANT NUMBER := -20015;
    c_invalid_domain                CONSTANT NUMBER := -20016;
    c_job_creation_failed           CONSTANT NUMBER := -20017;
    c_unsupported_entity_type       CONSTANT NUMBER := -20018;
    c_invalid_llm_response          CONSTANT NUMBER := -20019;

    -- Procedure to raise an error with an error code
    procedure raise_error (
        p_error_code in number
    );
    function get_message(p_code in number) return varchar2;

end lang_data_errors_pkg;
/

