Rem
Rem $Header: dbgendev/src/langdata/plsql/auth/auth_pkg.pkb
Rem saloshah_dbai_399/1 2024/10/21 15:21:20 saloshah Exp $
Rem
Rem auth_pkg.pkb
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      auth_pkg.pkb - Package body of the auth_pkg
Rem
Rem    DESCRIPTION
Rem      Defines the procedures/functions used for authorization
Rem 	 of the user in the current session
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/auth/auth_pkg.pkb
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jiangnhu    03/08/25 - Add assert_minimum_role_access
Rem    jiangnhu    02/06/25 - Add assert_app_expert_role
Rem    saloshah    10/21/24 - DBAI-399: Modify header
Rem    pryarla     10/16/24 - Created
Rem

CREATE OR REPLACE PACKAGE BODY lang_data_auth_pkg AS

    -- Function to return TRUE if the role is enabled, FALSE otherwise
    FUNCTION is_role_enabled (
        role_name IN VARCHAR2
    ) RETURN BOOLEAN IS
    BEGIN
        RETURN DBMS_SESSION.IS_ROLE_ENABLED(role_name);
    END is_role_enabled;

    PROCEDURE assert_app_expert_role IS
    BEGIN
        IF NOT lang_data_auth_pkg.is_role_enabled(
            lang_data_auth_pkg.c_lang_data_app_expert
        ) THEN
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_unauthorized_code
            );
        END IF;
    END assert_app_expert_role;

    PROCEDURE assert_minimum_role_access IS
    BEGIN
        IF NOT lang_data_auth_pkg.is_role_enabled(
            lang_data_auth_pkg.c_lang_data_app_expert
        ) AND NOT lang_data_auth_pkg.is_role_enabled(
            c_lang_data_user
        ) THEN
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_unauthorized_code
            );
        END IF;
    END assert_minimum_role_access;
END lang_data_auth_pkg;
/

