/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.dbtools.extension.apex.core.apexlang.APEXApplicationInstallOverrides;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;

public class APEXLangImporter {
    final Connection conn;
    final ScriptRunnerContext ctx;
    final APEXApplicationInstallOverrides overrides;

    public APEXLangImporter(Connection conn, ScriptRunnerContext ctx, APEXApplicationInstallOverrides overrides) {
        this.conn = conn;
        this.ctx = ctx;
        this.overrides = overrides;
    }

    public APEXLangSyntaxError importResult(APEXLangCompilationResult result) throws IOException {
        try {
            this.executePLSQL(result.getPlsqlOutput());
        }
        catch (SQLException e) {
            return APEXLangCompiler.parsePLSQLError((String)e.getMessage());
        }
        return null;
    }

    public String executePLSQL(String plSQL) throws SQLException, IOException {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            String string;
            try (BufferedOutputStream bufferedStream = new BufferedOutputStream(byteStream);){
                String encoding = ScriptRunnerContext.getOutputEncoding();
                String clearOverridesPLSQL = this.overrides.getClearOverridePLSQL(this.conn);
                String overridePLSQL = this.overrides.generateOverridePLSQL(this.conn);
                String executionPLSQL = clearOverridesPLSQL + overridePLSQL + plSQL + clearOverridesPLSQL;
                ScriptExecutor runner = new ScriptExecutor(executionPLSQL, this.conn);
                this.ctx.putProperty("output_stream_wrapper", (Object)new WrapListenBufferOutputStream((OutputStream)new BufferedOutputStream(System.out)));
                this.ctx.putProperty("SQLBLANKLINES", (Object)"ON");
                if (executionPLSQL.endsWith("/")) {
                    this.ctx.putProperty("script.runner.isslashstatement", (Object)"true");
                }
                for (Map.Entry<String, Object> entry : this.overrides.getOverrideMap().entrySet()) {
                    this.ctx.addBind(entry.getKey(), entry.getValue().toString());
                }
                runner.setScriptRunnerContext(this.ctx);
                runner.setOut(bufferedStream);
                runner.run();
                bufferedStream.flush();
                String outputStr = byteStream.toString(encoding);
                Boolean errorHappened = (Boolean)this.ctx.getProperty("sqldev.error");
                if (errorHappened.booleanValue()) {
                    this.conn.rollback();
                    if (!outputStr.isEmpty()) {
                        throw new SQLException(outputStr.trim());
                    }
                    throw new SQLException((String)runner.getScriptRunnerContext().getProperty("sqldev.last.err.message.forsqlcode"));
                }
                this.conn.commit();
                string = outputStr;
            }
            return string;
        }
    }
}

