/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter.internal;

import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.waiter.Waiter;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class SimpleWaiterImpl<REQUEST, RESPONSE>
implements Waiter<REQUEST, RESPONSE> {
    private final ExecutorService executorService;
    private final Callable<RESPONSE> callable;
    private final REQUEST request;

    @Override
    public RESPONSE execute() throws Exception {
        return this.callable.call();
    }

    @Override
    public Future<Void> execute(final AsyncHandler<REQUEST, RESPONSE> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){
            final /* synthetic */ SimpleWaiterImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void call() throws Exception {
                try {
                    Object response = this.this$0.callable.call();
                    asyncHandler.onSuccess(this.this$0.request, response);
                    return null;
                }
                catch (Exception e) {
                    asyncHandler.onError(this.this$0.request, e);
                    throw e;
                }
            }
        });
    }

    @ConstructorProperties(value={"executorService", "callable", "request"})
    public SimpleWaiterImpl(ExecutorService executorService, Callable<RESPONSE> callable, REQUEST request) {
        this.executorService = executorService;
        this.callable = callable;
        this.request = request;
    }

    public REQUEST getRequest() {
        return this.request;
    }
}

