/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class StringUtils
extends Enum<StringUtils> {
    private static final Random RANDOM;
    private static final /* synthetic */ StringUtils[] $VALUES;

    public static StringUtils[] values() {
        return (StringUtils[])$VALUES.clone();
    }

    public static StringUtils valueOf(String name) {
        return Enum.valueOf(StringUtils.class, name);
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isNotBlank(String s) {
        return !StringUtils.isBlank(s);
    }

    public static String join(Collection<?> objects, String delimiter) {
        if (objects == null) {
            return null;
        }
        return objects.stream().map(o -> o == null ? "" : o.toString()).collect(Collectors.joining(delimiter));
    }

    public static String replace(String template, Map<String, String> replacements, String prefix, String suffix) {
        String result = template;
        for (Map.Entry<String, String> e : replacements.entrySet()) {
            result = result.replaceAll(Pattern.quote(prefix) + Pattern.quote(e.getKey()) + Pattern.quote(suffix), e.getValue());
        }
        return result;
    }

    public static String randomPrint(int minLengthInclusive, int maxLengthExclusive) {
        int randomLength = 0;
        if (maxLengthExclusive - minLengthInclusive > 0) {
            randomLength = RANDOM.nextInt(maxLengthExclusive - minLengthInclusive);
        }
        return StringUtils.randomPrint(randomLength + minLengthInclusive);
    }

    public static String randomPrint(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = (char)(RANDOM.nextInt(94) + 32);
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String randomAlphabetic(int minLengthInclusive, int maxLengthExclusive) {
        int randomLength = 0;
        if (maxLengthExclusive - minLengthInclusive > 0) {
            randomLength = RANDOM.nextInt(maxLengthExclusive - minLengthInclusive);
        }
        return StringUtils.randomAlphabetic(randomLength + minLengthInclusive);
    }

    public static String randomAlphabetic(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int ch = RANDOM.nextInt(52);
            if (ch < 26) {
                sb.append((char)(ch + 65));
                continue;
            }
            sb.append((char)(ch + 97 - 26));
        }
        return sb.toString();
    }

    public static String random(int length, String allowed) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = RANDOM.nextInt(allowed.length());
            sb.append(allowed.charAt(index));
        }
        return sb.toString();
    }

    public static boolean isAnyBlank(String ... strings) {
        if (strings == null) {
            return false;
        }
        if (strings.length == 0) {
            return false;
        }
        for (String s : strings) {
            if (!StringUtils.isBlank(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneBlank(String ... strings) {
        return !StringUtils.isAnyBlank(strings);
    }

    public static boolean isAllBlank(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String s : strings) {
            if (StringUtils.isBlank(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static String upperCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase();
    }

    public static String left(String s, int length) {
        if (s == null) {
            return null;
        }
        if (length < 0) {
            return "";
        }
        return s.substring(0, Math.min(s.length(), length));
    }

    public static int length(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    public static boolean containsIgnoreCase(String s, String searchStr) {
        if (s == null || searchStr == null) {
            return false;
        }
        return s.toLowerCase().contains(searchStr.toLowerCase());
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean contains(String s, String searchStr) {
        if (s == null || searchStr == null) {
            return false;
        }
        return s.contains(searchStr);
    }

    public static String repeat(String substring, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(substring);
        }
        return sb.toString();
    }

    private static /* synthetic */ StringUtils[] $values() {
        return new StringUtils[0];
    }

    static {
        $VALUES = StringUtils.$values();
        RANDOM = new Random();
    }
}

