/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.util.internal.ComparableVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCompatibilityChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCompatibilityChecker.class);
    public static final String JAVA_MINIMUM_CLIENT_CODEGEN_VERSION_PROPERTY_NAME = "java.minimum.client.codegen.version";
    public static final String JAVA_MAXIMUM_CLIENT_CODEGEN_VERSION_PROPERTY_NAME = "java.maximum.client.codegen.version";
    public static final String JAVA_CLIENT_CODEGEN_VERSION_PROPERTY_NAME = "java.client.codegen.version";
    public static final String JAVA_MINIMUM_CLIENT_CODEGEN_VERSION_FROM_CLIENT_PROPERTY_NAME = "java.minimum.client.codegen.version.from.client";
    public static final String OCI_JAVASDK_CLIENT_VERSION_COMPATIBILITY_CHECK_SYSTEM_PROPERTY_NAME = "oci.javasdk.client.version.compatibility.check";
    private final VersionCompatibilityCheckMode versionCompatibilityCheckMode;
    private final String minimumClientCodegenVersion;
    private final String maximumClientCodegenVersion;
    private final String sdkVersion;

    public ClientCompatibilityChecker(Properties sdkProperties) {
        this(sdkProperties, ClientCompatibilityChecker.getVersionCompatibilityCheckModeFromSystemProperty());
    }

    private static VersionCompatibilityCheckMode getVersionCompatibilityCheckModeFromSystemProperty() {
        VersionCompatibilityCheckMode mode;
        try {
            String value = System.getProperty(OCI_JAVASDK_CLIENT_VERSION_COMPATIBILITY_CHECK_SYSTEM_PROPERTY_NAME, VersionCompatibilityCheckMode.ONCE.name());
            mode = VersionCompatibilityCheckMode.fromString(value);
        }
        catch (RuntimeException rte) {
            mode = VersionCompatibilityCheckMode.ONCE;
        }
        return mode;
    }

    public ClientCompatibilityChecker(Properties sdkProperties, VersionCompatibilityCheckMode versionCompatibilityCheckMode) {
        this.sdkVersion = ClientRuntime.extractSdkVersionFromProperties(sdkProperties);
        this.minimumClientCodegenVersion = ClientCompatibilityChecker.minClientCodegenVersion(sdkProperties);
        this.maximumClientCodegenVersion = ClientCompatibilityChecker.maxClientCodegenVersion(sdkProperties);
        this.versionCompatibilityCheckMode = versionCompatibilityCheckMode;
        this.versionCompatibilityCheckMode.logInitialMessage();
    }

    static String minClientCodegenVersion(Properties sdkProperties) {
        return sdkProperties.getProperty(JAVA_MINIMUM_CLIENT_CODEGEN_VERSION_PROPERTY_NAME);
    }

    static String maxClientCodegenVersion(Properties sdkProperties) {
        return sdkProperties.getProperty(JAVA_MAXIMUM_CLIENT_CODEGEN_VERSION_PROPERTY_NAME);
    }

    public String getMinimumClientCodegenVersion() {
        return this.minimumClientCodegenVersion;
    }

    public String getMaximumClientCodegenVersion() {
        return this.maximumClientCodegenVersion;
    }

    public boolean isClientCodegenVersionCompatible(String clientClassName, String clientCodegenVersion, Optional<String> javaMinimumClientCodegenVersionFromClient, Logger logger) {
        Optional<ComparableVersion> maybeMaximumVerObj;
        Optional<ComparableVersion> maybeClientVerObj;
        Optional<Boolean> previousResult = this.versionCompatibilityCheckMode.getPreviousResult(clientClassName);
        if (previousResult.isPresent()) {
            return previousResult.get();
        }
        boolean minVersionHasError = false;
        boolean clientVersionHasError = false;
        Optional<ComparableVersion> maybeMinimumVerObj = ComparableVersion.buildComparableVersion(this.minimumClientCodegenVersion);
        if (!maybeMinimumVerObj.isPresent()) {
            minVersionHasError = true;
        }
        if (!(maybeClientVerObj = ComparableVersion.buildComparableVersion(ClientCompatibilityChecker.getCodegenVersionWithoutSdkVersion(clientCodegenVersion))).isPresent()) {
            clientVersionHasError = true;
        }
        if (minVersionHasError && !clientVersionHasError && (maybeMaximumVerObj = ComparableVersion.buildComparableVersion(this.maximumClientCodegenVersion)).isPresent()) {
            ComparableVersion minimumVerFromClientObj;
            if (maybeClientVerObj.get().compareTo(maybeMaximumVerObj.get()) == 0) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("The client is compatible with the oci-java-sdk-common version '%s', since it was generated with codegen version '%s', which is exactly the maximum of the compatible codegen version range", this.sdkVersion, clientCodegenVersion));
                }
                return this.versionCompatibilityCheckMode.setPreviousResult(clientClassName, true);
            }
            if (javaMinimumClientCodegenVersionFromClient.isPresent() && (minimumVerFromClientObj = new ComparableVersion(javaMinimumClientCodegenVersionFromClient.get())).compareTo(maybeMaximumVerObj.get()) <= 0 && maybeMaximumVerObj.get().compareTo(maybeClientVerObj.get()) <= 0) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("The client is compatible with the oci-java-sdk-common version '%s', since it was generated using codegen version '%s', and at the time the client was generated, it was known that codegen version '%s' is backward-compatible to codegen version '%s'; therefore, the compatible codegen version range '%s' to '%s' applies", this.sdkVersion, clientCodegenVersion, clientCodegenVersion, javaMinimumClientCodegenVersionFromClient.get(), javaMinimumClientCodegenVersionFromClient.get(), clientCodegenVersion));
                }
                return this.versionCompatibilityCheckMode.setPreviousResult(clientClassName, true);
            }
        }
        if (minVersionHasError) {
            if (this.minimumClientCodegenVersion == null) {
                logger.warn("java.minimum.client.codegen.version not found in sdk.properties file. Cannot determine if the client is compatible with the SDK common library");
            } else {
                logger.warn("java.minimum.client.codegen.version '" + this.minimumClientCodegenVersion + " 'could not be parsed. Cannot determine if the client is compatible with the SDK common library");
            }
        }
        if (clientVersionHasError) {
            if (clientCodegenVersion == null) {
                logger.warn("java.client.codegen.version not found in client.properties file. Cannot determine if the client is compatible with the SDK common library");
            } else {
                logger.warn("java.client.common.library.version '" + clientCodegenVersion + "' could not be parsed. Cannot determine if the client is too old for the SDK common library");
            }
        }
        if (clientVersionHasError || minVersionHasError) {
            return this.versionCompatibilityCheckMode.setPreviousResult(clientClassName, false);
        }
        if (maybeClientVerObj.get().compareTo(maybeMinimumVerObj.get()) < 0) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("The client is too old for the oci-java-sdk-common version '%s'. The client was generated with codegen version '%s', but this oci-java-sdk-common version is only backward-compatible down to codegen version '%s'", this.sdkVersion, clientCodegenVersion, this.minimumClientCodegenVersion));
            }
            return this.versionCompatibilityCheckMode.setPreviousResult(clientClassName, false);
        }
        maybeMaximumVerObj = ComparableVersion.buildComparableVersion(this.maximumClientCodegenVersion);
        if (!maybeMaximumVerObj.isPresent()) {
            if (this.maximumClientCodegenVersion == null) {
                logger.warn("java.maximum.client.codegen.version not found in sdk.properties file. Cannot determine if the client is too new for the SDK common library");
            } else {
                logger.warn("java.maximum.client.codegen.version " + this.maximumClientCodegenVersion + " could not be parsed. Cannot determine if the client is too new for the SDK common library");
            }
            return this.versionCompatibilityCheckMode.setPreviousResult(clientClassName, false);
        }
        ComparableVersion maximumVerObj = new ComparableVersion(this.maximumClientCodegenVersion);
        if (maybeClientVerObj.get().compareTo(maximumVerObj) > 0) {
            ComparableVersion minimumVerObj;
            boolean clientIsTooNew = true;
            if (javaMinimumClientCodegenVersionFromClient.isPresent() && (minimumVerObj = new ComparableVersion(javaMinimumClientCodegenVersionFromClient.get())).compareTo(maybeMinimumVerObj.get()) == 0) {
                clientIsTooNew = false;
            }
            if (clientIsTooNew) {
                if (logger.isWarnEnabled() && javaMinimumClientCodegenVersionFromClient.isPresent()) {
                    logger.warn(String.format("The client is too new for the oci-java-sdk-common version '%s'. The client was generated using codegen version '%s', which is backward-compatible down to codegen version '%s', but this version of oci-java-sdk-common requires codegen version '%s' or older", this.sdkVersion, clientCodegenVersion, javaMinimumClientCodegenVersionFromClient.get(), this.maximumClientCodegenVersion));
                }
                return this.versionCompatibilityCheckMode.setPreviousResult(clientClassName, false);
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("The client is compatible with the oci-java-sdk-common version '%s', since the client was generated using codegen version '%s', and at the time the client was generated, it was known that codegen version '%s' is backward-compatible to codegen version '%s'; therefore, the compatible codegen version range '%s' to '%s' applies", this.sdkVersion, clientCodegenVersion, clientCodegenVersion, this.minimumClientCodegenVersion, this.minimumClientCodegenVersion, clientCodegenVersion));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info(String.format("The client is compatible with the oci-java-sdk-common version '%s', since the client was generated using codegen version '%s', which is in the compatible codegen version range '%s' to '%s'", this.sdkVersion, clientCodegenVersion, this.minimumClientCodegenVersion, this.maximumClientCodegenVersion));
        }
        return this.versionCompatibilityCheckMode.setPreviousResult(clientClassName, true);
    }

    static String getCodegenVersionWithoutSdkVersion(String clientCodegenVersion) {
        if (clientCodegenVersion == null) {
            return null;
        }
        int pos = clientCodegenVersion.indexOf(45);
        if (pos >= 0) {
            clientCodegenVersion = clientCodegenVersion.substring(0, pos);
        }
        return clientCodegenVersion;
    }

    public static enum VersionCompatibilityCheckMode {
        ALWAYS(new AlwaysVersionCompatibilityCheckModeImpl()),
        ONCE(new OnceVersionCompatibilityCheckModeImpl()),
        NEVER(new NeverVersionCompatibilityCheckModeImpl());

        private final VersionCompatibilityCheckModeImpl impl;

        private VersionCompatibilityCheckMode(VersionCompatibilityCheckModeImpl impl) {
            this.impl = impl;
        }

        public static VersionCompatibilityCheckMode fromString(String s) {
            return VersionCompatibilityCheckMode.valueOf(s.toUpperCase());
        }

        public void logInitialMessage() {
            this.impl.logInitialMessage();
        }

        public Optional<Boolean> getPreviousResult(String clientClassName) {
            return this.impl.getPreviousResult(clientClassName);
        }

        public boolean setPreviousResult(String clientClassName, boolean previousResult) {
            return this.impl.setPreviousResult(clientClassName, previousResult);
        }
    }

    static class OnceVersionCompatibilityCheckModeImpl
    implements VersionCompatibilityCheckModeImpl {
        private final Map<String, Boolean> previousResults = new HashMap<String, Boolean>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        OnceVersionCompatibilityCheckModeImpl() {
        }

        @Override
        public void logInitialMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Boolean> getPreviousResult(String clientClassName) {
            Lock readLock = this.lock.readLock();
            readLock.lock();
            try {
                if (this.previousResults.containsKey(clientClassName)) {
                    Optional<Boolean> optional = Optional.of(this.previousResults.get(clientClassName));
                    return optional;
                }
                Optional<Boolean> optional = Optional.empty();
                return optional;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPreviousResult(String clientClassName, boolean previousResult) {
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.previousResults.put(clientClassName, previousResult);
            }
            finally {
                writeLock.unlock();
                return previousResult;
            }
        }
    }

    static class AlwaysVersionCompatibilityCheckModeImpl
    implements VersionCompatibilityCheckModeImpl {
        AlwaysVersionCompatibilityCheckModeImpl() {
        }

        @Override
        public void logInitialMessage() {
        }

        @Override
        public Optional<Boolean> getPreviousResult(String clientClassName) {
            return Optional.empty();
        }

        @Override
        public boolean setPreviousResult(String clientClassName, boolean previousResult) {
            return previousResult;
        }
    }

    static class NeverVersionCompatibilityCheckModeImpl
    implements VersionCompatibilityCheckModeImpl {
        NeverVersionCompatibilityCheckModeImpl() {
        }

        @Override
        public void logInitialMessage() {
            LOG.info("Not checking client/common library codegen version compatibility; compatibility checks will always return 'true'");
        }

        @Override
        public Optional<Boolean> getPreviousResult(String clientClassName) {
            return Optional.of(true);
        }

        @Override
        public boolean setPreviousResult(String clientClassName, boolean previousResult) {
            return previousResult;
        }
    }

    static interface VersionCompatibilityCheckModeImpl {
        public void logInitialMessage();

        public Optional<Boolean> getPreviousResult(String var1);

        public boolean setPreviousResult(String var1, boolean var2);
    }
}

