/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.internal;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.Region;
import com.oracle.bmc.util.VisibleForTesting;
import com.oracle.bmc.util.internal.FileUtils;
import com.oracle.bmc.util.internal.StringUtils;
import java.io.File;

public final class Alloy
extends Enum<Alloy> {
    private static final String DEFAULT_ALLOY_CONFIG_FILE_PATH = "~/.oci/alloy-config.json";
    private static final String OCI_ALLOY_CONFIG_FILE_PATH = "OCI_ALLOY_CONFIG_FILE_PATH";
    private static final String OCI_ALLOY_REGION_COEXIST_ENV_VAR = "OCI_ALLOY_REGION_COEXIST";
    private static boolean shouldUseOnlyAlloyRegions;
    private static final /* synthetic */ Alloy[] $VALUES;

    public static Alloy[] values() {
        return (Alloy[])$VALUES.clone();
    }

    public static Alloy valueOf(String name) {
        return Enum.valueOf(Alloy.class, name);
    }

    public static boolean doesAlloyConfigExist() {
        return Alloy.doesAlloyFileExists() || Alloy.doesAlloyEnvExists();
    }

    public static boolean doesAlloyFileExists() {
        File file = new File(FileUtils.expandUserHome(DEFAULT_ALLOY_CONFIG_FILE_PATH));
        return file.isFile();
    }

    public static boolean doesAlloyEnvExists() {
        return System.getenv(OCI_ALLOY_CONFIG_FILE_PATH) != null;
    }

    public static boolean isAlloyRegionCoexistEnabled() {
        String ociRegionCoexistFromEnvVar = System.getenv(OCI_ALLOY_REGION_COEXIST_ENV_VAR);
        if (StringUtils.isNotBlank(ociRegionCoexistFromEnvVar)) {
            return StringUtils.equalsIgnoreCase(ociRegionCoexistFromEnvVar, "true");
        }
        return Region.isAlloyRegionCoexistEnabled();
    }

    public static boolean shouldUseOnlyAlloyRegions() {
        return shouldUseOnlyAlloyRegions;
    }

    public static String getAlloyEnvContent() {
        return System.getenv(OCI_ALLOY_CONFIG_FILE_PATH);
    }

    public static String getAlloyConfigFilePath() {
        if (Alloy.doesAlloyEnvExists()) {
            return Alloy.getAlloyEnvContent();
        }
        return DEFAULT_ALLOY_CONFIG_FILE_PATH;
    }

    public static void throwUnknownAlloyRegionIfAppropriate(String regionId, Throwable e) {
        if (Alloy.shouldUseOnlyAlloyRegions()) {
            throw new IllegalArgumentException("Unknown regionId " + regionId + ", region information not defined in Alloy configuration.", e);
        }
    }

    public static void throwDisabledServiceExceptionIfAppropriate(String serviceName) {
        if (!Region.isServiceEnabled(serviceName)) {
            throw new IllegalArgumentException("The Alloy configuration disabled service '" + serviceName + "'. This behavior is controlled by OCI_SDK_ENABLED_SERVICES_SET variable. Please check if your local alloy-config.json file configured the service you're targeting or contact the cloud provider on the availability of this service");
        }
    }

    @InternalSdk
    @VisibleForTesting
    public static void resetAlloyRegionCoexistStatus() {
        shouldUseOnlyAlloyRegions = Alloy.doesAlloyConfigExist() && !Alloy.isAlloyRegionCoexistEnabled();
    }

    private static /* synthetic */ Alloy[] $values() {
        return new Alloy[0];
    }

    static {
        $VALUES = Alloy.$values();
        shouldUseOnlyAlloyRegions = Alloy.doesAlloyConfigExist() && !Alloy.isAlloyRegionCoexistEnabled();
    }
}

