/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.importprotecteddatabase;

import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import reactor.util.annotation.NonNull;

public class VerifyDatabaseStep
implements Step {
    ProtectedDatabase protectedDatabase;
    private RecoveryClientManager recoveryClientManager;
    WorkflowLogger logger;

    public VerifyDatabaseStep(@NonNull ProtectedDatabase protectedDatabase, @NonNull RecoveryClientManager recoveryClientManager, @NonNull WorkflowLogger logger) {
        this.protectedDatabase = protectedDatabase;
        this.recoveryClientManager = recoveryClientManager;
        this.logger = logger;
    }

    @Override
    public Result run() {
        String dbUniqueName = this.protectedDatabase.getDbUniqueName();
        LifecycleState state = this.protectedDatabase.getLifecycleState();
        String id = this.protectedDatabase.getId();
        FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
        ProtectedDatabaseCache protectedDatabaseCache = fleetAgentContext.getProtectedDatabaseCache();
        if (protectedDatabaseCache.getOcid() != null && !protectedDatabaseCache.getOcid().equals(id)) {
            String error = "There is already an OCID in the cache.";
            return new Result(Status.FAILED, error);
        }
        if (state.equals((Object)LifecycleState.Deleted) || state.equals((Object)LifecycleState.Deleting)) {
            String error = "Cannot import a database with " + state.getValue() + " state.";
            return new Result(Status.FAILED, error);
        }
        if (state.equals((Object)LifecycleState.DeleteScheduled)) {
            try {
                this.recoveryClientManager.cancelProtectedDatabaseDeletion(id);
            }
            catch (BmcException e) {
                Workflow.logException(e, this.logger.getLogger());
                String error = String.format("The database state is %s but the agent failed to cancel database deletion.", LifecycleState.DeleteScheduled);
                return new Result(Status.FAILED, error);
            }
        }
        protectedDatabaseCache.setOcid(id);
        protectedDatabaseCache.setVpcUserName(this.protectedDatabase.getVpcUserName());
        protectedDatabaseCache.save();
        return new Result(Status.SUCCESS);
    }
}

