/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import java.sql.Connection;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.extension.rcv.workflows.AddScheduleWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ScheduleTasksStep
implements Step {
    private Connection conn;
    private WorkflowLogger logger;
    private ScriptRunnerContext ctx;

    public ScheduleTasksStep(Connection conn, WorkflowLogger logger, ScriptRunnerContext ctx) {
        this.conn = conn;
        this.logger = logger;
        this.ctx = ctx;
    }

    @Override
    public Result run() {
        JobType[] types;
        this.logger.log(Level.INFO, "Scheduling tasks");
        Result result = new Result(Status.SUCCESS);
        for (JobType type : types = new JobType[]{JobType.BACKUP, JobType.ROTATE_VPC_CREDS, JobType.REMOVE_LOGS}) {
            AddScheduleWorkflow addScheduleWf = new AddScheduleWorkflow(this.conn, this.ctx, type).add(true);
            addScheduleWf.setLogger(this.logger);
            result = addScheduleWf.run(false);
            if (!result.getStatus().equals((Object)Status.FAILED)) continue;
            return result;
        }
        return result;
    }
}

