/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import java.util.logging.Level;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.BackupManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class BackupControlFileStep
implements Step {
    private Database database;
    private WorkflowLogger logger;

    public BackupControlFileStep(Database database, WorkflowLogger logger) {
        this.database = database;
        this.logger = logger;
    }

    @Override
    public Result run() {
        this.logger.log(Level.INFO, "Backing up control file");
        SystemCommand.ExecutionResult rmanResult = BackupManager.backupControlFile(this.database, this.logger.getLogFile(), this.logger.getLogger());
        if (rmanResult.getReturnCode() != 0) {
            return Result.apdRmanBackupCfError(String.valueOf(rmanResult.getReturnCode()));
        }
        return new Result(Status.SUCCESS);
    }
}

