/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.nio.file.Path;
import java.sql.Connection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJob;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJobs;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.scheduler.SchedulerFile;
import oracle.dbtools.raptor.scheduler.exceptions.InvalidJobException;
import oracle.dbtools.raptor.scheduler.job.Job;
import org.apache.logging.log4j.core.util.CronExpression;

public class ShowScheduleWorkflow
extends ProtectedDatabaseWorkflow {
    public ShowScheduleWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.SHOW_SCHEDULE, conn, ctx);
    }

    @Override
    public Result run(boolean verbose) {
        List jobs;
        SchedulerFile schedulerFile;
        WorkflowLogger logger = this.getWorkflowLogger();
        try {
            schedulerFile = new SchedulerFile();
        }
        catch (Exception e) {
            this.logException(e);
            return Result.schedulerFileError(RcvMessages.format("SCHEDULER_FILE_INIT_ERROR_MSG", new Object[0]));
        }
        Database database = this.getDatabase();
        JobType[] jobTypes = new JobType[]{JobType.BACKUP, JobType.ROTATE_VPC_CREDS};
        ArrayList<FleetAgentJob> fleetAgentJobs = new ArrayList<FleetAgentJob>();
        for (JobType type : jobTypes) {
            fleetAgentJobs.add(FleetAgentJobs.get(this.getDbUniqueName(), type));
        }
        try {
            jobs = schedulerFile.loadJobs();
        }
        catch (InvalidJobException e) {
            this.logException(e);
            return Result.schedulerLoadJobsSyntaxError();
        }
        catch (Exception e) {
            this.logException(e);
            return Result.schedulerFileError(RcvMessages.format("SCHEDULER_FILE_LOAD_JOBS_ERROR_MSG", new Object[0]));
        }
        boolean foundJobs = false;
        block8: for (FleetAgentJob fleetAgentJob : fleetAgentJobs) {
            for (Job job : jobs) {
                if (!job.getName().equals(fleetAgentJob.getJobName())) continue;
                foundJobs = true;
                logger.log(Level.INFO, "Name:                  " + job.getName());
                logger.log(Level.INFO, "Cron:                  " + job.getCron());
                logger.log(Level.INFO, "Payload:               " + job.getPayload());
                Optional<Path> lastLogOptional = fleetAgentJob.getLastExecutedLog();
                lastLogOptional.ifPresent(path -> logger.log(Level.INFO, "Most recent job log:   " + String.valueOf(path)));
                CronExpression quartzCron = null;
                try {
                    quartzCron = new CronExpression(job.getCron());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (quartzCron == null) continue block8;
                Date now = new Date();
                Date nextScheduledTime = quartzCron.getNextValidTimeAfter(now);
                logger.log(Level.INFO, "Next execution time:   " + String.valueOf(nextScheduledTime) + System.lineSeparator());
                continue block8;
            }
        }
        if (!foundJobs) {
            logger.log(Level.INFO, "No schedule found for this database.");
        }
        return new Result(Status.SUCCESS);
    }
}

