/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.recovery.model.Metrics;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.ProtectionPolicy;
import java.sql.Connection;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    private RecoveryClientManager recoveryClientManager;
    private String protectedDatabaseId;
    private ParsedCommand command;
    private boolean printFullJson;

    public ShowProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.SHOW_DATABASE, conn, ctx);
        this.command = command;
    }

    @Override
    public void initState() {
        String endpoint = (String)this.command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        this.protectedDatabaseId = (String)this.command.getOptionValue((Id)RCVOptions.Options.ID);
        this.printFullJson = this.command.isFlagSet((Id)RCVOptions.Options.FULL);
        GlobalMetadata globalMetadata = GlobalMetadata.load();
        if (endpoint == null) {
            endpoint = this.getDatabase().getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(globalMetadata.getAuthentication(), endpoint, this.getWorkflowLogger().getLogger());
    }

    @Override
    public Result run(boolean verbose) {
        this.initState();
        WorkflowLogger logger = this.getWorkflowLogger();
        if (verbose) {
            logger.log(Level.INFO, "Log file: " + logger.getLogFile());
        }
        if (this.protectedDatabaseId == null) {
            this.protectedDatabaseId = this.getProtectedDatabaseOcid();
        }
        ProtectedDatabase protectedDatabase = null;
        try {
            protectedDatabase = this.recoveryClientManager.getProtectedDatabase(this.protectedDatabaseId);
        }
        catch (BmcException e) {
            return Result.rcvGetProtectedDatabaseError(this.protectedDatabaseId, this.getDatabase().getFleetAgentContext().getProtectedDatabaseCache().getMetadataFile());
        }
        if (protectedDatabase == null) {
            logger.log(Level.INFO, "Database is not onboarded to Recovey Service. Please run 'rcv add protected_database' to onboard it.");
            return new Result(Status.SUCCESS);
        }
        if (this.printFullJson) {
            logger.log(Level.INFO, protectedDatabase.toString());
        } else {
            Metrics metrics = protectedDatabase.getMetrics();
            ProtectionPolicy protectionPolicy = this.recoveryClientManager.getProtectionPolicy(protectedDatabase.getProtectionPolicyId());
            Float unprotectedWindow = metrics.getUnprotectedWindowInSeconds();
            String notAvailable = "Information not available";
            logger.log(Level.INFO, "DB Unique Name:    " + protectedDatabase.getDbUniqueName());
            logger.log(Level.INFO, "Display Name:      " + protectedDatabase.getDisplayName());
            logger.log(Level.INFO, "OCID:              " + protectedDatabase.getId());
            logger.log(Level.INFO, "Compartment ID:    " + protectedDatabase.getCompartmentId());
            logger.log(Level.INFO, "Status:            " + String.valueOf(protectedDatabase.getLifecycleState()));
            logger.log(Level.INFO, "VPC User:          " + protectedDatabase.getVpcUserName());
            logger.log(Level.INFO, "Real-time Redo:    " + protectedDatabase.getIsRedoLogsShipped());
            logger.log(Level.INFO, "Protection Policy: ");
            logger.log(Level.INFO, "\tName:               " + protectionPolicy.getDisplayName());
            logger.log(Level.INFO, "\tID:                 " + protectedDatabase.getProtectionPolicyId());
            logger.log(Level.INFO, "\tRetention Period:  " + protectionPolicy.getBackupRetentionPeriodInDays() + " days");
            logger.log(Level.INFO, "Health:            " + String.valueOf(protectedDatabase.getHealth()));
            logger.log(Level.INFO, "Health Details:    " + protectedDatabase.getHealthDetails());
            logger.log(Level.INFO, "Metrics:");
            logger.log(Level.INFO, "\tMinimum Recovery Time:     " + metrics.getMinimumRecoveryNeededInDays() + " days");
            logger.log(Level.INFO, "\tUnprotected Window:        " + (String)(unprotectedWindow == null ? notAvailable : unprotectedWindow + " seconds"));
            logger.log(Level.INFO, "\tRetention Period:          " + metrics.getRetentionPeriodInDays() + " days");
        }
        return new Result(Status.SUCCESS);
    }
}

