/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import com.oracle.bmc.recovery.responses.DeleteRecoveryServiceSubnetResponse;
import java.sql.Connection;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class RemoveRecoveryServiceSubnet
extends Workflow {
    private String id;
    private WorkflowLogger logger;
    private RecoveryClientManager recoveryClientManager;

    public RemoveRecoveryServiceSubnet(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.REMOVE_RECOVERY_SERVICE_SUBNET, conn, ctx);
        this.id = (String)command.getOptionValue((Id)RCVOptions.Options.ID);
        this.logger = this.getWorkflowLogger();
        String endpoint = (String)command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        if (endpoint == null && conn != null) {
            endpoint = RCVCommandBase.getDatabase(conn).getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(endpoint, this.logger.getLogger());
    }

    @Override
    public Result run(boolean verbose) {
        if (verbose) {
            this.logger.info("Log file: " + this.logger.getLogFile());
        }
        RecoveryServiceSubnet rss = this.recoveryClientManager.getRecoveryServiceSubnet(this.id);
        LifecycleState state = rss.getLifecycleState();
        switch (state) {
            case Deleting: 
            case DeleteScheduled: {
                return new Result(Status.SKIPPED, "Recovery service subnet is already being deleted.");
            }
            case Deleted: {
                return new Result(Status.SKIPPED, "Recovery service subnet has already been deleted.");
            }
            case Active: 
            case Failed: {
                return this.deleteRecoveryServiceSubnet();
            }
        }
        return new Result(Status.FAILED, "Cannot remove the recovery service subnet because it is '" + String.valueOf(state) + "'. Please try again later.");
    }

    public Result deleteRecoveryServiceSubnet() {
        DeleteRecoveryServiceSubnetResponse response = this.recoveryClientManager.deleteRecoveryServiceSubnet(this.id);
        this.logger.log(Level.FINE, response.toString());
        this.logger.info("Waiting for recovery service subnet to be deleted");
        LifecycleState state = this.recoveryClientManager.waitForResourceUpdate(600, 20, () -> this.recoveryClientManager.getRecoveryServiceSubnet(this.id).getLifecycleState());
        if (state.equals((Object)LifecycleState.Deleting)) {
            return Result.removeResourceTimeout(RCVObjects.RECOVERY_SERVICE_SUBNET, this.id);
        }
        if (!state.equals((Object)LifecycleState.Deleted)) {
            return Result.verifyLifecycleStatusError("recovery service subnet", state.getValue(), LifecycleState.Deleting.getValue(), LifecycleState.Deleted.getValue());
        }
        return new Result(Status.SUCCESS);
    }
}

