/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.DeletionSchedule;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.extension.rcv.models.ora.OraConfig;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.utils.TnsnamesHelper;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.DisableRealtimeRedoWorkflow;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.RemoveScheduleWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class RemoveProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    private RecoveryClientManager recoveryClientManager;
    private WorkflowLogger logger;
    private boolean force;
    private boolean remove;
    private boolean localOnly;
    private String deleteAfter;
    private ParsedCommand command;
    private Connection conn;
    private ScriptRunnerContext ctx;
    private List<SshHelper> sshConnections = new ArrayList<SshHelper>();
    private Database database;

    public RemoveProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(command.isFlagSet((Id)RCVOptions.Options.LOCAL), command.isFlagSet((Id)RCVOptions.Options.FORCE), (String)command.getOptionValue((Id)RCVOptions.Options.DELETE_AFTER), conn, ctx);
    }

    public RemoveProtectedDatabaseWorkflow(boolean local, boolean force, String deleteAfter, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.REMOVE_DATABASE, conn, ctx);
        this.localOnly = local;
        this.force = force;
        this.deleteAfter = deleteAfter;
        this.logger = super.getWorkflowLogger();
        this.conn = conn;
        this.ctx = ctx;
        this.database = this.getDatabase();
        this.remove = true;
        this.sshConnections = this.database.getDatabaseMetadataCache().getSshConnections(this.getWorkflowLogger().getLogger());
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.REMOVE_DATABASE) + ".lock");
    }

    @Override
    public void initState() {
        String dbUniqueName = this.getDbUniqueName();
        Database database = this.getDatabase();
        String id = database.getOcid();
        this.logger.log(Level.INFO, "Protected database to remove:");
        this.logger.log(Level.INFO, "\tDB Unique Name: " + dbUniqueName);
        this.logger.log(Level.INFO, "\tOCID:           " + id);
        if (!this.force) {
            this.logger.log(Level.INFO, "WARNING: Removing the protected database can result in data loss.");
            this.remove = Utils.confirm("Are you sure you want to remove this protected database (yes/no)? ");
        }
        if (this.remove) {
            ArrayList<Step> steps = new ArrayList<Step>();
            steps.add(new DisableRealtimeRedo());
            steps.add(new RemoveBackupJob());
            if (!this.localOnly) {
                steps.add(new RunRemoveProtectedDatabaseOnRemoteNodes());
                steps.add(new RemoveProtectedDatabase());
            }
            steps.add(new RemoveVpcCredentials());
            steps.add(new RemoveMetadataDirectory());
            super.setSteps(steps);
        } else {
            this.logger.log(Level.INFO, "User chose to not remove the protected database. Exiting...");
        }
    }

    private class DisableRealtimeRedo
    implements Step {
        private DisableRealtimeRedo() {
        }

        @Override
        public Result run() {
            if (RemoveProtectedDatabaseWorkflow.this.remove) {
                RemoveProtectedDatabaseWorkflow.this.logger.log(Level.INFO, "Checking realtime redo configuration");
                DisableRealtimeRedoWorkflow disableRealtimeRedoWorkflow = new DisableRealtimeRedoWorkflow(true, RemoveProtectedDatabaseWorkflow.this.conn, RemoveProtectedDatabaseWorkflow.this.ctx);
                disableRealtimeRedoWorkflow.setLogger(RemoveProtectedDatabaseWorkflow.this.logger);
                return disableRealtimeRedoWorkflow.run(false);
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RemoveBackupJob
    implements Step {
        private RemoveBackupJob() {
        }

        @Override
        public Result run() {
            if (RemoveProtectedDatabaseWorkflow.this.remove) {
                RemoveProtectedDatabaseWorkflow.this.logger.log(Level.INFO, "Removing scheduled jobs");
                RemoveScheduleWorkflow removeScheduleWorkflow = new RemoveScheduleWorkflow(RemoveProtectedDatabaseWorkflow.this.conn, RemoveProtectedDatabaseWorkflow.this.ctx, List.of(JobType.BACKUP, JobType.ROTATE_VPC_CREDS), true);
                removeScheduleWorkflow.setLogger(RemoveProtectedDatabaseWorkflow.this.logger);
                return removeScheduleWorkflow.run(false);
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RunRemoveProtectedDatabaseOnRemoteNodes
    implements Step {
        private RunRemoveProtectedDatabaseOnRemoteNodes() {
        }

        @Override
        public Result run() {
            if (!RemoveProtectedDatabaseWorkflow.this.localOnly && RemoveProtectedDatabaseWorkflow.this.remove && !RemoveProtectedDatabaseWorkflow.this.sshConnections.isEmpty()) {
                RemoveProtectedDatabaseWorkflow.this.logger.info("Removing metadata on remote nodes");
                RCVCommand rcvCommand = new RCVCommand(RCVCommand.SubCommand.REMOVE_DATABASE).addFlag(RCVOptions.Options.FORCE).addFlag(RCVOptions.Options.LOCAL);
                Database database = RemoveProtectedDatabaseWorkflow.this.getDatabase();
                FleetAgentContext fleetAgentContext = database.getFleetAgentContext();
                String connectionName = fleetAgentContext.getConnectionName();
                String scriptPath = fleetAgentContext.getScriptsDirectory() + File.separator + "remove_database.sql";
                NamedConnectionsManager.saveConnection(RemoveProtectedDatabaseWorkflow.this.getConnection(), RemoveProtectedDatabaseWorkflow.this.getContext(), connectionName);
                NamedConnectionsManager.propagateNamedConnectionToRemoteNodes(connectionName, RemoveProtectedDatabaseWorkflow.this.sshConnections);
                for (SshHelper remoteSsh : RemoveProtectedDatabaseWorkflow.this.sshConnections) {
                    String remoteHost = remoteSsh.getHost();
                    SystemCommand.ExecutionResult result = remoteSsh.executeRcvCommand(connectionName, rcvCommand, scriptPath, database.getDatabaseMetadataCache().getOracleSid());
                    RemoveProtectedDatabaseWorkflow.this.logger.log(Level.FINE, String.format("rcv remove database on remote host %s completed with status %s", remoteHost, result.getReturnCode()));
                    RemoveProtectedDatabaseWorkflow.this.logger.log(Level.FINE, result.getOutput());
                    if (result.getReturnCode() == 0) continue;
                    return new Result(Status.FAILED, "Failed to remove protected database on remote host " + remoteHost);
                }
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RemoveProtectedDatabase
    implements Step {
        private RemoveProtectedDatabase() {
        }

        @Override
        public Result run() {
            if (RemoveProtectedDatabaseWorkflow.this.remove) {
                ProtectedDatabase protectedDatabase;
                String id = RemoveProtectedDatabaseWorkflow.this.database.getOcid();
                RemoveProtectedDatabaseWorkflow.this.logger.log(Level.INFO, "Removing protected database");
                String endpoint = RemoveProtectedDatabaseWorkflow.this.database.getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
                RemoveProtectedDatabaseWorkflow.this.recoveryClientManager = new RecoveryClientManager(endpoint, RemoveProtectedDatabaseWorkflow.this.logger.getLogger());
                DeletionSchedule deletionSchedule = DeletionSchedule.DeleteAfterRetentionPeriod;
                if (RemoveProtectedDatabaseWorkflow.this.deleteAfter.equalsIgnoreCase("72_hours")) {
                    deletionSchedule = DeletionSchedule.DeleteAfter72Hours;
                }
                try {
                    protectedDatabase = RemoveProtectedDatabaseWorkflow.this.recoveryClientManager.waitForRemoveProtectedDatabase(id, deletionSchedule);
                }
                catch (Exception e) {
                    RemoveProtectedDatabaseWorkflow.this.logException(e);
                    return Result.rpdRemoveProtectedDbError();
                }
                LifecycleState state = protectedDatabase.getLifecycleState();
                if (!state.equals((Object)LifecycleState.Deleted) && !state.equals((Object)LifecycleState.DeleteScheduled)) {
                    if (state.equals((Object)LifecycleState.Deleting)) {
                        return Result.rpdRemoveProtectedDbTmt(state.getValue(), LifecycleState.Deleted.getValue());
                    }
                    return Result.rpdRemoveLifecycleError(state.getValue());
                }
                String msg = String.format("Protected database %s state is %s.", id, state.getValue());
                RemoveProtectedDatabaseWorkflow.this.logger.log(Level.FINE, msg);
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RemoveVpcCredentials
    implements Step {
        private RemoveVpcCredentials() {
        }

        @Override
        public Result run() {
            RemoveProtectedDatabaseWorkflow.this.logger.info("Removing VPC user credentials");
            String walletLocation = RemoveProtectedDatabaseWorkflow.this.database.getFleetAgentContext().getProtectedDatabaseCache().getWalletLocation();
            if (!walletLocation.equals(RCVCommandBase.getWalletDirectory(RemoveProtectedDatabaseWorkflow.this.database.getDbUniqueName()))) {
                OracleWallet wallet = WalletManager.createWallet(walletLocation);
                try {
                    List<String> aliases = WalletManager.getAliasesForUser(wallet, RemoveProtectedDatabaseWorkflow.this.database.getFleetAgentContext().getProtectedDatabaseCache().getVpcUserName());
                    WalletManager.deleteCredentials(wallet, aliases);
                }
                catch (IOException | OracleSecretStoreException e) {
                    String error = String.format("Failed to remove VPC credentials from wallet %s: %s", walletLocation, e.getMessage());
                    RemoveProtectedDatabaseWorkflow.this.logger.log(Level.FINE, error);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class RemoveMetadataDirectory
    implements Step {
        private RemoveMetadataDirectory() {
        }

        @Override
        public Result run() {
            RemoveProtectedDatabaseWorkflow.this.logger.info("Removing metadata");
            String dbUniqueName = RemoveProtectedDatabaseWorkflow.this.getDbUniqueName();
            RCVCommandBase.removeProtectedDatabaseMetadata(RemoveProtectedDatabaseWorkflow.this.getConnection());
            FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
            String metadataDirectory = fleetAgentContext.getMetadataDirectory();
            if (Files.exists(Paths.get(metadataDirectory, new String[0]), new LinkOption[0])) {
                try {
                    Utils.deleteDirectory(metadataDirectory);
                }
                catch (IOException e) {
                    RemoveProtectedDatabaseWorkflow.this.logException(e);
                    return Result.rpdRemoveMetadataError(metadataDirectory);
                }
            }
            String rcvTnsnamesPath = fleetAgentContext.getTnsnamesPath();
            String defaultTnsnamesPath = TnsnamesHelper.getDefaultTnsnamesFile(dbUniqueName);
            OraConfig defaultTnsnames = OraConfig.load(defaultTnsnamesPath);
            defaultTnsnames.removeIfile(rcvTnsnamesPath);
            try {
                defaultTnsnames.write(defaultTnsnamesPath);
            }
            catch (IOException e) {
                Workflow.logException(e, RemoveProtectedDatabaseWorkflow.this.logger.getLogger());
                return new Result(Status.FAILED, "Failed to remove IFILE " + rcvTnsnamesPath + " from " + defaultTnsnamesPath);
            }
            RemoveProtectedDatabaseWorkflow.this.logger.log(Level.FINE, "Successfully deleted protected database " + RemoveProtectedDatabaseWorkflow.this.database.getDbUniqueName());
            return new Result(Status.SUCCESS);
        }
    }
}

