/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ChangeRecoveryServiceSubnetCompartmentDetails;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.UpdateRecoveryServiceSubnetDetails;
import com.oracle.bmc.recovery.requests.ChangeRecoveryServiceSubnetCompartmentRequest;
import com.oracle.bmc.recovery.requests.UpdateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.responses.UpdateRecoveryServiceSubnetResponse;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureRecoveryServiceSubnetWorkflow
extends Workflow {
    private String endpoint;
    private String id;
    private String compartmentId;
    private List<String> subnets;
    private List<String> nsgs;
    private String displayName;
    private Connection conn;

    public ConfigureRecoveryServiceSubnetWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.CONFIGURE_RECOVERY_SERVICE_SUBNET, conn, ctx);
        this.conn = conn;
        this.endpoint = (String)command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        this.id = (String)command.getOptionValue((Id)RCVOptions.Options.ID);
        this.compartmentId = (String)command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.displayName = (String)command.getOptionValue((Id)RCVOptions.Options.NAME);
        this.subnets = (List)command.getOptionValue((Id)RCVOptions.Options.SUBNETS);
        this.nsgs = (List)command.getOptionValue((Id)RCVOptions.Options.NETWORK_SECURITY_GROUPS);
    }

    @Override
    public Result run(boolean verbose) {
        LifecycleState state;
        UpdateRecoveryServiceSubnetResponse response;
        UpdateRecoveryServiceSubnetRequest request;
        if (this.compartmentId == null && this.displayName == null && this.subnets == null && this.nsgs == null) {
            String error = String.format("Please provide at least one of %s, %s, %s, %s", new Object[]{RCVOptions.Options.COMPARTMENT_ID, RCVOptions.Options.NAME, RCVOptions.Options.SUBNETS, RCVOptions.NETWORK_SECURITY_GROUPS_O});
            throw Result.missingOptionException(error);
        }
        WorkflowLogger logger = this.getWorkflowLogger();
        if (this.endpoint == null && this.conn != null) {
            this.endpoint = RCVCommandBase.getDatabase(this.conn).getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        RecoveryClientManager recoveryClientManager = new RecoveryClientManager(this.endpoint, logger.getLogger());
        if (this.displayName != null || this.subnets != null || this.nsgs != null) {
            request = ConfigureRecoveryServiceSubnetWorkflow.updateRecoveryServiceSubnetRequest(this.id, this.displayName, this.subnets, this.nsgs);
            response = recoveryClientManager.updateRecoveryServiceSubnet(request);
            logger.log(Level.FINE, response.toString());
            logger.log(Level.INFO, "Updating recovery service subnet");
            state = recoveryClientManager.waitForResourceUpdate(600, 20, () -> recoveryClientManager.getRecoveryServiceSubnet(this.id).getLifecycleState());
            if (state.equals((Object)LifecycleState.Updating)) {
                return Result.updResourceStatusTmt("recovery service subnet", this.id);
            }
            if (!state.equals((Object)LifecycleState.Active)) {
                return Result.verifyLifecycleStatusError("recovery service subnet", state.getValue(), LifecycleState.Active.getValue(), LifecycleState.Updating.getValue());
            }
        }
        if (this.compartmentId != null) {
            request = ConfigureRecoveryServiceSubnetWorkflow.changeRecoveryServiceSubnetCompartmentRequest(this.id, this.compartmentId);
            response = recoveryClientManager.changeRecoveryServiceSubnetCompartment((ChangeRecoveryServiceSubnetCompartmentRequest)request);
            logger.log(Level.FINE, response.toString());
            logger.log(Level.INFO, "Changing recovery service subnet compartment");
            state = recoveryClientManager.waitForResourceUpdate(600, 20, () -> recoveryClientManager.getRecoveryServiceSubnet(this.id).getLifecycleState());
            if (state.equals((Object)LifecycleState.Updating)) {
                return Result.updResourceStatusTmt("recovery service subnet", this.id);
            }
            if (!state.equals((Object)LifecycleState.Active)) {
                return Result.verifyLifecycleStatusError("recovery service subnet", state.getValue(), LifecycleState.Active.getValue(), LifecycleState.Updating.getValue());
            }
        }
        return new Result(Status.SUCCESS);
    }

    public static UpdateRecoveryServiceSubnetRequest updateRecoveryServiceSubnetRequest(String rssId, String displayName, List<String> subnets, List<String> nsgs) {
        if (displayName != null || subnets != null) {
            UpdateRecoveryServiceSubnetDetails.Builder builder = new UpdateRecoveryServiceSubnetDetails.Builder();
            if (displayName != null) {
                builder.displayName(displayName);
            }
            if (subnets != null && !subnets.isEmpty()) {
                builder.subnets(subnets);
            }
            if (nsgs != null && !nsgs.isEmpty()) {
                builder.nsgIds(nsgs);
            }
            return new UpdateRecoveryServiceSubnetRequest.Builder().updateRecoveryServiceSubnetDetails(builder.build()).recoveryServiceSubnetId(rssId).build();
        }
        return null;
    }

    public static ChangeRecoveryServiceSubnetCompartmentRequest changeRecoveryServiceSubnetCompartmentRequest(String rssId, String compartmentId) {
        ChangeRecoveryServiceSubnetCompartmentDetails details = new ChangeRecoveryServiceSubnetCompartmentDetails.Builder().compartmentId(compartmentId).build();
        return new ChangeRecoveryServiceSubnetCompartmentRequest.Builder().recoveryServiceSubnetId(rssId).changeRecoveryServiceSubnetCompartmentDetails(details).build();
    }
}

