/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.oci;

import com.oracle.bmc.OCID;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import java.io.IOException;
import java.net.http.HttpConnectTimeoutException;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.oci.InstanceMetadata;
import oracle.dbtools.extension.rcv.oci.InstanceMetadataClient;
import oracle.dbtools.extension.rcv.workflows.Result;

public class OCIUtils {
    public static boolean amIInOCI() {
        try {
            InstanceMetadata instanceMetadata = new InstanceMetadata(InstanceMetadataClient.getInstanceMetadataResponse());
        }
        catch (HttpConnectTimeoutException e) {
            return false;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
        return true;
    }

    public static Region getRegion() {
        Region.enableInstanceMetadataService();
        Region.registerFromInstanceMetadataService();
        Region region = Region.getRegionFromImds();
        return region;
    }

    public static String getResourcePrincipalRptEndpoint() {
        Region region = OCIUtils.getRegion();
        String regionString = region.getRegionId();
        return "https://database." + regionString + ".oraclecloud.com";
    }

    public static String getRecoveryServiceEndpoint() {
        Region region = OCIUtils.getRegion();
        String regionString = region.getRegionId();
        return OCIUtils.getRecoveryServiceEndpoint(regionString);
    }

    public static String getRecoveryServiceEndpoint(String region) {
        return "https://recovery." + region + ".oci.oraclecloud.com";
    }

    public static String getResourceTypeFromOcid(String ocid) {
        if (OCID.isValid((String)ocid)) {
            return ocid.split("\\.")[1];
        }
        return null;
    }

    public static String getRealmFromOcid(String ocid) {
        if (OCID.isValid((String)ocid)) {
            return ocid.split("\\.")[2];
        }
        return null;
    }

    public static String getRegionFromOcid(String ocid) {
        if (OCID.isValid((String)ocid)) {
            return ocid.split("\\.")[3];
        }
        return null;
    }

    public static boolean isTenancyOcid(String ocid) {
        String resourceType = OCIUtils.getResourceTypeFromOcid(ocid);
        return resourceType != null && resourceType.equalsIgnoreCase("tenancy");
    }

    public static AbstractAuthenticationDetailsProvider getAuthenticationDetailsProvider(OCIAuthentication authentication) {
        OCIAuthentication.Method method = authentication.getMethod();
        if (method.equals((Object)OCIAuthentication.Method.RESOURCE_PRINCIPAL)) {
            String ociResourcePrincipalRptEndpoint = OCIUtils.getResourcePrincipalRptEndpoint();
            return ResourcePrincipalAuthenticationDetailsProvider.builder().build_1_1(ociResourcePrincipalRptEndpoint, null);
        }
        try {
            return new ConfigFileAuthenticationDetailsProvider(authentication.getConfigFile(), authentication.getProfileName());
        }
        catch (IOException e) {
            throw Result.ociAuthFileConfigException(e, authentication.getConfigFile());
        }
    }
}

