/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.ora;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.models.ora.Node;
import oracle.dbtools.extension.rcv.models.ora.OraConfig;
import oracle.dbtools.extension.rcv.utils.Utils;

public class Sqlnet
extends OraConfig {
    public Sqlnet() {
    }

    public Sqlnet(List<Node<String>> entries) {
        super(entries);
    }

    public static Sqlnet load(String file) {
        return new Sqlnet(OraConfig.getEntries(file));
    }

    public static Path getSqlnetOraPath() {
        String tnsAdmin;
        Path sqlnetPath = Paths.get(Utils.getOracleBaseHome(), "network", "admin", "sqlnet.ora");
        if (!Files.exists(sqlnetPath, new LinkOption[0]) && (tnsAdmin = System.getenv("TNS_ADMIN")) != null && Files.exists(Paths.get(tnsAdmin, "sqlnet.ora"), new LinkOption[0])) {
            sqlnetPath = Paths.get(tnsAdmin, "sqlnet.ora");
        }
        return sqlnetPath;
    }

    public void appendValueToParameterList(String parameter, String value) {
        Node<String> entry = super.getNode(parameter);
        boolean update = false;
        Object newValue = "";
        if (entry == null) {
            update = true;
            newValue = "(" + value + ")";
        } else {
            String currentValue = Sqlnet.toString(entry, 0);
            Pattern p = Pattern.compile("[\\(]+\\s*(\\S+)\\s*[\\)]+$");
            Matcher m = p.matcher(currentValue);
            if (m.find() && !m.group(1).contains(value)) {
                update = true;
                newValue = "(" + m.group(1) + "," + value + ")";
            }
        }
        if (update) {
            this.updateParameter(parameter, (String)newValue);
        }
    }

    public void removeValueFromParameterList(String parameter, String value) {
        Node<String> entry = super.getNode(parameter);
        if (entry != null) {
            if (!entry.getChildren().isEmpty()) {
                CharSequence[] newValueArr;
                String currentValue = Sqlnet.toString(entry.getChildren().get(0), 0);
                String[] valueArr = currentValue.replaceAll("^\\(|\\)$", "").split(",\\s*", 0);
                if (valueArr.length != (newValueArr = (String[])Arrays.stream(valueArr).filter(val -> !val.equalsIgnoreCase(value)).toArray(String[]::new)).length) {
                    if (newValueArr.length == 0) {
                        super.removeParameter(parameter);
                    } else {
                        this.updateParameter(parameter, "(" + String.join((CharSequence)", ", newValueArr) + ")");
                    }
                }
            } else {
                super.removeParameter(parameter);
            }
        }
    }

    @Override
    public synchronized Node<String> updateParameter(String parameter, String value) {
        Node<String> node = this.getNode(parameter);
        if (node == null) {
            node = new Node<String>(parameter);
            super.getEntries().add(node);
        }
        if (!value.isEmpty()) {
            value = value.replaceAll("[\\n\\s]", "");
            Pattern p = Pattern.compile("^\\([^()]*\\)$");
            Matcher m = p.matcher(value);
            if (value.charAt(0) != '(' || m.matches()) {
                node.setChildren(List.of(new Node<String>(value)));
            } else {
                ArrayList lines = new ArrayList();
                Node<String> newEntry = Sqlnet.parseLine(node.getValue() + "=" + value);
                if (newEntry != null) {
                    node.setChildren(newEntry.getChildren());
                }
            }
        }
        return node;
    }

    public void setTls(boolean tls) {
        String AUTH_SERVICES = "SQLNET.AUTHENTICATION_SERVICES";
        Map<String, String> tlsParameters = Map.of("SSL_VERSION", "1.2", "SSL_CLIENT_AUTHENTICATION", "FALSE");
        if (tls) {
            this.updateParameter("SSL_VERSION", "1.2");
            this.updateParameter("SSL_CLIENT_AUTHENTICATION", "FALSE");
            this.appendValueToParameterList("SQLNET.AUTHENTICATION_SERVICES", "BEQ");
            this.appendValueToParameterList("SQLNET.AUTHENTICATION_SERVICES", "TCPS");
        } else {
            super.removeParameter("SSL_VERSION");
            super.removeParameter("SSL_CLIENT_AUTHENTICATION");
            this.removeValueFromParameterList("SQLNET.AUTHENTICATION_SERVICES", "TCPS");
        }
    }

    public void updateWallet(String walletLocation) {
        this.updateParameter("SQLNET.WALLET_OVERRIDE", "true");
        this.updateParameter("WALLET_LOCATION", "(SOURCE=(METHOD=FILE)(METHOD_DATA=(DIRECTORY=" + walletLocation + ")))");
    }
}

