/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.jobs;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.jobs.TimeUnit;
import oracle.dbtools.raptor.scheduler.SchedulerFile;
import oracle.dbtools.raptor.scheduler.job.Job;

public abstract class FleetAgentJob {
    private String jobName;
    private RCVCommand rcvCommand;

    public FleetAgentJob(String jobName, RCVCommand rcvCommand) {
        this.jobName = jobName;
        this.rcvCommand = rcvCommand;
    }

    public String getJobName() {
        return this.jobName;
    }

    public RCVCommand getCommand() {
        return this.rcvCommand;
    }

    public Job getCurrentJob(SchedulerFile schedulerFile) {
        List jobs = schedulerFile.loadJobs();
        for (Job job : jobs) {
            if (!job.getName().equals(this.jobName)) continue;
            return job;
        }
        return null;
    }

    public static int[] getSchedule(Job job, TimeUnit timeUnit) {
        if (job == null) {
            return null;
        }
        String cron = job.getCron();
        String[] fields = cron.split("\\s+");
        int index = -1;
        if (timeUnit.equals((Object)TimeUnit.SECOND)) {
            index = 0;
        } else if (timeUnit.equals((Object)TimeUnit.MINUTE)) {
            index = 1;
        } else if (timeUnit.equals((Object)TimeUnit.HOUR)) {
            index = 2;
        } else if (timeUnit.equals((Object)TimeUnit.DAY)) {
            index = 3;
        } else if (timeUnit.equals((Object)TimeUnit.MONTH)) {
            index = 4;
        } else if (timeUnit.equals((Object)TimeUnit.WEEK)) {
            index = 5;
        } else if (timeUnit.equals((Object)TimeUnit.YEAR)) {
            index = 6;
        }
        if (index == -1) {
            return null;
        }
        int currentStart = 0;
        int currentInterval = 0;
        if (fields[index].contains("/")) {
            String[] strings = fields[index].split("/");
            if (strings.length == 2) {
                try {
                    currentInterval = Integer.parseInt(strings[1]);
                    if (!strings[0].equals("*")) {
                        currentStart = Integer.parseInt(strings[0]);
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
                return new int[]{currentStart, currentInterval};
            }
            return null;
        }
        if (fields[index].equals("*") || fields[index].equals("?")) {
            return new int[]{0, 0};
        }
        return null;
    }

    public abstract Optional<Path> getLastExecutedLog();

    public abstract boolean isLocalOnly();

    public abstract TimeUnit getTimeUnit();

    public abstract int getDefaultInterval();

    public abstract Job createJob(Integer var1, Integer var2);
}

