/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.database;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;

public class ProtectedDatabaseCache {
    private static final int VERSION = 1;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private String dbUniqueName;
    private String ocid;
    private String vpcUserName;
    private String metadataFile;
    private String libraLocation;
    private String walletLocation;
    private String compartmentId;
    private String endpoint;
    private int version;
    private long lastModified;

    private ProtectedDatabaseCache() {
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getOcid() {
        this.readLock.lock();
        try {
            String string = this.ocid;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getCompartmentId() {
        this.readLock.lock();
        try {
            String string = this.compartmentId;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLibraLocation() {
        this.writeLock.lock();
        try {
            String defaultLocation;
            String oracleHome;
            if (this.libraLocation == null && (oracleHome = RCVCommandBase.getOracleHome()) != null && Files.exists(Paths.get(defaultLocation = RCVCommandBase.getOracleHome() + File.separatorChar + "lib" + File.separatorChar + "libra.so", new String[0]), new LinkOption[0])) {
                this.libraLocation = defaultLocation;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.readLock.lock();
        try {
            String string = this.libraLocation;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVpcUserName() {
        this.writeLock.lock();
        try {
            if (this.vpcUserName == null) {
                Optional<String> vpcUserNameOptional = ConfigurationManager.getVpcUserNameFromRcvConf(this.dbUniqueName);
                if (vpcUserNameOptional.isEmpty()) {
                    RecoveryClientManager recoveryClientManager = new RecoveryClientManager(this.getEndpoint(), null);
                    ProtectedDatabase protectedDatabase = recoveryClientManager.getProtectedDatabase(this.ocid);
                    this.vpcUserName = protectedDatabase.getVpcUserName();
                } else {
                    this.vpcUserName = vpcUserNameOptional.get();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.readLock.lock();
        try {
            String string = this.vpcUserName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getMetadataFile() {
        this.readLock.lock();
        try {
            String string = this.metadataFile;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getWalletLocation() {
        this.writeLock.lock();
        try {
            if (this.walletLocation == null) {
                this.walletLocation = RCVCommandBase.getWalletDirectory(this.dbUniqueName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.readLock.lock();
        try {
            String string = this.walletLocation;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getCredentialAlias() {
        return ConfigurationManager.getCatalogAlias(this.dbUniqueName);
    }

    public String getEndpoint() {
        this.writeLock.lock();
        try {
            if (this.endpoint == null) {
                this.endpoint = RecoveryClientManager.getDefaultEndpoint();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.readLock.lock();
        try {
            String string = this.endpoint;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<String> getRecoveryApplianceAliases() {
        return ConfigurationManager.getWalletEntriesFromRcvConf(this.dbUniqueName);
    }

    public long getLastModified() {
        this.readLock.lock();
        try {
            long l = this.lastModified;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setOcid(String ocid) {
        this.writeLock.lock();
        try {
            this.ocid = ocid;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setCompartmentId(String compartmentId) {
        this.writeLock.lock();
        try {
            this.compartmentId = compartmentId;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setLibraLocation(String libraLocation) {
        this.writeLock.lock();
        try {
            this.libraLocation = libraLocation;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setVpcUserName(String vpcUserName) {
        this.writeLock.lock();
        try {
            this.vpcUserName = vpcUserName;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setEndpoint(String endpoint) {
        this.writeLock.lock();
        try {
            this.endpoint = endpoint;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setWalletLocation(String location) {
        this.writeLock.lock();
        try {
            this.walletLocation = location;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clearCache() {
        this.writeLock.lock();
        try {
            this.ocid = null;
            this.compartmentId = null;
            this.vpcUserName = null;
            this.walletLocation = null;
            this.endpoint = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static ProtectedDatabaseCache load(String dbUniqueName) {
        return ProtectedDatabaseCache.load(dbUniqueName, RCVCommandBase.getMetadataPath(dbUniqueName));
    }

    public static ProtectedDatabaseCache load(String dbUniqueName, String file) {
        File f = new File(file);
        ProtectedDatabaseCache cache = new ProtectedDatabaseCache();
        cache.dbUniqueName = dbUniqueName;
        cache.metadataFile = file;
        if (Files.exists(Paths.get(file, new String[0]), new LinkOption[0])) {
            JsonObject jsonObject;
            try (FileInputStream fileStream = new FileInputStream(f);
                 JsonReader jsonReader = Json.createReader((InputStream)fileStream);){
                jsonObject = jsonReader.readObject();
            }
            catch (Exception e) {
                throw Result.pdbMetadataLoadException(file, e);
            }
            cache.lastModified = f.lastModified();
            if (jsonObject.containsKey((Object)"ocid")) {
                cache.ocid = jsonObject.getString("ocid");
            }
            if (jsonObject.containsKey((Object)"compartmentId")) {
                cache.compartmentId = jsonObject.getString("compartmentId");
            }
            if (jsonObject.containsKey((Object)"vpcUserName")) {
                cache.vpcUserName = jsonObject.getString("vpcUserName");
            }
            if (jsonObject.containsKey((Object)"libraLocation")) {
                cache.libraLocation = jsonObject.getString("libraLocation");
            }
            if (jsonObject.containsKey((Object)"walletLocation")) {
                cache.walletLocation = jsonObject.getString("walletLocation");
            }
            if (jsonObject.containsKey((Object)"version")) {
                cache.version = jsonObject.getInt("version", 1);
            }
            if (jsonObject.containsKey((Object)"recoveryServiceEndpoint")) {
                cache.endpoint = jsonObject.getString("recoveryServiceEndpoint");
            }
        } else {
            cache.lastModified = System.currentTimeMillis();
            cache.version = 1;
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        block17: {
            this.writeLock.lock();
            try {
                JsonObject jsonObject;
                if (!Files.exists(Paths.get(this.metadataFile, new String[0]), new LinkOption[0])) break block17;
                File f = new File(this.metadataFile);
                try (FileInputStream fileStream = new FileInputStream(f);
                     JsonReader jsonReader = Json.createReader((InputStream)fileStream);){
                    jsonObject = jsonReader.readObject();
                }
                catch (Exception e) {
                    throw Result.pdbMetadataLoadException(this.metadataFile, e);
                }
                this.lastModified = f.lastModified();
                this.ocid = jsonObject.containsKey((Object)"ocid") ? jsonObject.getString("ocid") : null;
                this.compartmentId = jsonObject.containsKey((Object)"compartmentId") ? jsonObject.getString("compartmentId") : null;
                this.vpcUserName = jsonObject.containsKey((Object)"vpcUserName") ? jsonObject.getString("vpcUserName") : null;
                this.libraLocation = jsonObject.containsKey((Object)"libraLocation") ? jsonObject.getString("libraLocation") : null;
                this.walletLocation = jsonObject.containsKey((Object)"walletLocation") ? jsonObject.getString("walletLocation") : null;
                if (jsonObject.containsKey((Object)"recoveryServiceEndpoint")) {
                    this.endpoint = jsonObject.getString("recoveryServiceEndpoint");
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private JsonObjectBuilder toJsonObjectBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder().add("dbUniqueName", this.dbUniqueName);
        builder.add("version", this.version);
        if (this.ocid != null) {
            builder.add("ocid", this.ocid);
        }
        if (this.compartmentId != null) {
            builder.add("compartmentId", this.compartmentId);
        }
        if (this.vpcUserName != null) {
            builder.add("vpcUserName", this.vpcUserName);
        }
        if (this.libraLocation != null) {
            builder.add("libraLocation", this.libraLocation);
        }
        if (this.walletLocation != null) {
            builder.add("walletLocation", this.walletLocation);
        }
        if (this.endpoint != null) {
            builder.add("recoveryServiceEndpoint", this.endpoint);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.writeLock.lock();
        try {
            JsonObjectBuilder builder = this.toJsonObjectBuilder();
            String metadataFile = this.getMetadataFile();
            Utils.createParentDirectoryForFile(metadataFile);
            File f = new File(this.getMetadataFile());
            Map<String, Boolean> jsonWriterConfig = Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriterFactory writerFactory = Json.createWriterFactory(jsonWriterConfig);
            try (JsonWriter jsonWriter = writerFactory.createWriter((OutputStream)new FileOutputStream(f));){
                jsonWriter.writeObject(builder.build());
            }
            catch (Exception e) {
                throw Result.pdbMetadataSaveException(metadataFile, e);
            }
            this.lastModified = f.lastModified();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

