/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.database;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.models.RCVContext;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.utils.WalletManager;

public class DatabaseMetadataCache {
    private Connection conn;
    private String dbUniqueName;
    private String walletRoot;
    private String serverSeps;
    private String oracleSid;
    private String dbId;
    private String dbName;
    private Integer instanceId;
    private List<String> remoteHostNames;
    private List<SshHelper> sshConnections;

    public DatabaseMetadataCache(Connection conn) {
        this.conn = conn;
        this.dbUniqueName = DatabaseUtils.getDbUniqueName(conn);
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getWalletRoot() {
        if (this.walletRoot == null) {
            this.walletRoot = WalletManager.getWalletRoot(this.conn);
        }
        return this.walletRoot;
    }

    public String getServerSeps() {
        if (this.serverSeps == null) {
            String walletRoot = this.getWalletRoot();
            if (walletRoot == null) {
                return null;
            }
            this.serverSeps = String.join((CharSequence)File.separator, walletRoot, "server_seps");
        }
        return this.serverSeps;
    }

    public String getOracleSid() {
        if (this.oracleSid == null) {
            this.oracleSid = DatabaseUtils.getInstanceName(this.conn);
        }
        return this.oracleSid;
    }

    public String getDbId() {
        if (this.dbId == null) {
            this.dbId = DatabaseUtils.getDbId(this.conn);
        }
        return this.dbId;
    }

    public String getDbName() {
        if (this.dbName == null) {
            this.dbName = DatabaseUtils.getDbName(this.conn);
        }
        return this.dbName;
    }

    public int getInstanceId() {
        if (this.instanceId == null) {
            this.instanceId = DatabaseUtils.getNodeId(this.conn);
            if (this.instanceId == null) {
                throw new RuntimeException("Failed to get instance ID from gv$instance.");
            }
        }
        return this.instanceId;
    }

    public List<String> getRemoteHostNames() {
        if (this.remoteHostNames == null || this.remoteHostNames.isEmpty()) {
            this.remoteHostNames = DatabaseUtils.getRemoteHostNames(this.conn);
        }
        return this.remoteHostNames;
    }

    public List<SshHelper> getSshConnections() {
        return this.getSshConnections(null);
    }

    public List<SshHelper> getSshConnections(Logger logger) {
        if (this.sshConnections == null || this.sshConnections.isEmpty()) {
            this.getRemoteHostNames();
            this.sshConnections = new ArrayList<SshHelper>();
            for (String node : this.remoteHostNames) {
                this.sshConnections.add(RCVContext.getSshConnection(node, logger));
            }
        }
        return this.sshConnections;
    }

    public boolean runsOnMultipleNodes() {
        return !this.getRemoteHostNames().isEmpty();
    }
}

