/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.database;

import java.sql.Connection;
import java.util.Optional;
import oracle.dbtools.extension.rcv.models.database.DatabaseMetadataCache;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.FullDatabaseConfig;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;

public class Database {
    private Connection conn;
    private String dbUniqueName;
    private DatabaseMetadataCache databaseMetadataCache;
    private Optional<FullDatabaseConfig> databaseConfig;
    private FleetAgentContext fleetAgentContext;

    public Database(Connection conn) {
        this.conn = conn;
        this.dbUniqueName = DatabaseUtils.getDbUniqueName(conn);
        this.databaseMetadataCache = new DatabaseMetadataCache(conn);
        this.fleetAgentContext = FleetAgentContext.get(this.dbUniqueName);
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Optional<FullDatabaseConfig> getDatabaseConfig() {
        if (this.databaseConfig == null) {
            this.databaseConfig = FullDatabaseConfig.getDatabaseConfig(this.dbUniqueName);
        }
        return this.databaseConfig;
    }

    public DatabaseMetadataCache getDatabaseMetadataCache() {
        return this.databaseMetadataCache;
    }

    public FleetAgentContext getFleetAgentContext() {
        return this.fleetAgentContext;
    }

    public String getOcid() {
        return this.fleetAgentContext.getProtectedDatabaseCache().getOcid();
    }
}

