/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

public class FleetEngineResponse<T> {
    private T data;
    private Status status;
    private String statusMessage;

    public FleetEngineResponse(Status status, String statusMessage, T data) {
        this.status = status;
        this.statusMessage = statusMessage;
        this.data = data;
    }

    public FleetEngineResponse(int statusCode, String statusMessage, T data) {
        this.status = Status.fromInt(statusCode);
        this.statusMessage = statusMessage;
        this.data = data;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.statusMessage;
    }

    public T getData() {
        return this.data;
    }

    public static enum Status {
        SUCCESS(300),
        FAIL_DATABASE_NOT_CONFIGURED(401),
        FAIL_DATABASE_NOT_REGISTERED(402),
        FAIL_INCORRECT_ACTION_ID(403),
        FAIL_SCRIPT_EXPIRED(404),
        FAIL_INCORRECT_CONFIG_NAME(405),
        FAIL_INCORRECT_CONFIG_VALUE(406),
        FAIL_INCORRECT_AGENT_ID(407),
        CE_FAIL_RETRY_NEXT_ACTION(408),
        CE_FAIL_RETRY_GET_ACTION(409),
        CE_FAIL_RETRY_ACTION_STATUS(410),
        CE_FAIL_DATABASE_SUSPENDED(411),
        CE_FAIL_DATABASE_DELETED(412),
        CE_FAIL_NULL_INPUT(413),
        UNKNOWN_VALUE(-1);

        private final int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Status fromInt(int i) {
            for (Status status : Status.values()) {
                if (status.getValue() != i) continue;
                return status;
            }
            return UNKNOWN_VALUE;
        }
    }
}

