/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.raptor.utils.TNSHelper;

public class SCANListener {
    private static final Pattern networkNumPattern = Pattern.compile("SCAN Listeners for network\\s*(\\d+):");
    private static final Pattern endpointsPattern = Pattern.compile("Endpoints:\\s*(\\S+)");
    private int networkNum;
    private Endpoint[] endpoints;
    private static List<SCANListener> listeners;

    private SCANListener(int networkNum, Endpoint[] endpoints) {
        this.networkNum = networkNum;
        this.endpoints = endpoints;
    }

    public int getNetworkNum() {
        return this.networkNum;
    }

    public Endpoint[] getEndpoints() {
        return this.endpoints;
    }

    public static List<SCANListener> getListeners() {
        return SCANListener.getListeners(TNSHelper.getOracleHome());
    }

    public static List<SCANListener> getListeners(String oracleHome) {
        if (listeners != null && !listeners.isEmpty()) {
            return listeners;
        }
        listeners = new ArrayList<SCANListener>();
        String srvctl = String.join((CharSequence)File.separator, oracleHome, "bin", "srvctl");
        SystemCommand.ExecutionResult result = new SystemCommand().run(srvctl, "config", "scan_listener");
        if (result.getReturnCode() == 0) {
            String[] output = result.getOutput().trim().split("\n");
            Integer networkNum = null;
            for (String line : output) {
                Matcher matcher = networkNumPattern.matcher(line = line.trim());
                if (matcher.matches()) {
                    networkNum = Integer.parseInt(matcher.group(1));
                    continue;
                }
                matcher = endpointsPattern.matcher(line);
                if (!matcher.matches()) continue;
                String value = matcher.group(1);
                String[] endpointValues = value.split("/");
                Endpoint[] endpoints = new Endpoint[endpointValues.length];
                if (endpointValues.length > 0) {
                    for (int i = 0; i < endpointValues.length; ++i) {
                        String[] fields = endpointValues[i].split(":");
                        if (fields.length != 2) continue;
                        endpoints[i] = new Endpoint(fields[0], Integer.parseInt(fields[1]));
                    }
                }
                if (endpoints.length <= 0 || networkNum == null) continue;
                listeners.add(new SCANListener(networkNum, endpoints));
            }
        }
        return listeners;
    }

    public static Optional<SCANListener> getListenerWithNetworkNum(String oracleHome, int networkNum) {
        listeners = SCANListener.getListeners(oracleHome);
        for (SCANListener listener : listeners) {
            if (listener.networkNum != networkNum) continue;
            return Optional.of(listener);
        }
        return Optional.empty();
    }

    public static class Endpoint {
        private String protocol;
        private int port;

        public Endpoint(String protocol, int port) {
            this.protocol = protocol;
            this.port = port;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public int getPort() {
            return this.port;
        }
    }
}

