/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands.transformers;

import java.io.IOException;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.extension.rcv.commands.completer.RCVCompartmentCompleter;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.net.commands.completers.CompartmentCompleter;
import oracle.dbtools.net.commands.completers.CompartmentPathMapper;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.util.Logger;

public class RCVCompartmentTransformer
implements Transformer<String, String> {
    private final CompartmentPathMapper compartmentPathMapper;
    private final CompartmentCompleter compartmentCompleter;

    public RCVCompartmentTransformer(CompartmentPathMapper compartmentPathMapper, CompartmentCompleter compartmentCompleter) {
        this.compartmentPathMapper = compartmentPathMapper;
        this.compartmentCompleter = compartmentCompleter;
    }

    public RCVCompartmentTransformer() {
        this(new CompartmentPathMapper(), RCVCompartmentCompleter.ofDisplayNames());
    }

    public String transform(String rawValue, TransformContext context, Environment environment) {
        if (!rawValue.isBlank()) {
            try {
                OCIAuthentication authentication = GlobalMetadata.load().getAuthentication();
                OCIProfile profile = this.compartmentCompleter.getProfile(authentication.getConfigFile(), authentication.getProfileName());
                return this.compartmentPathMapper.pathToOcid(profile, rawValue).orElse(rawValue);
            }
            catch (IOException | RuntimeException e) {
                Logger.warn(this.getClass(), (String)e.getMessage(), (Throwable)e);
            }
        }
        return rawValue;
    }
}

