/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands.completer;

import com.oracle.bmc.recovery.model.ProtectedDatabaseSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.completer.BaseOCIDatabaseRecoveryCompleter;
import oracle.dbtools.extension.rcv.oci.OCIDatabaseRecoveryClient;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public class ProtectedDatabaseCompleter
extends BaseOCIDatabaseRecoveryCompleter<ProtectedDatabaseSummary>
implements Transformer<String, String> {
    private final List<ProtectedDatabaseSummary> result = new ArrayList<ProtectedDatabaseSummary>();

    private ProtectedDatabaseCompleter(Function<ProtectedDatabaseSummary, String> mapper) {
        super(mapper);
    }

    public static ProtectedDatabaseCompleter of(Function<ProtectedDatabaseSummary, String> mapper) {
        return new ProtectedDatabaseCompleter(mapper);
    }

    public static ProtectedDatabaseCompleter ofIds() {
        return ProtectedDatabaseCompleter.of(ProtectedDatabaseSummary::getId);
    }

    public static ProtectedDatabaseCompleter ofNames() {
        return ProtectedDatabaseCompleter.of(ProtectedDatabaseSummary::getDisplayName);
    }

    protected List<ProtectedDatabaseSummary> listItems(OCIDatabaseRecoveryClient client, String tenantId, Map<String, Object> transformedOptionsMap) {
        Object compartmentId = transformedOptionsMap.get(RCVOptions.COMPARTMENT_ID_O.getId().toString());
        this.result.clear();
        this.result.addAll(client.listProtectedDatabases(compartmentId == null ? tenantId : (String)compartmentId));
        return this.result;
    }

    public String transform(String rawValue, TransformContext context, Environment environment) {
        return this.result.stream().filter(policy -> policy.getDisplayName().equalsIgnoreCase(rawValue)).map(ProtectedDatabaseSummary::getId).findFirst().orElse(rawValue);
    }
}

