/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands;

import java.sql.Connection;
import java.util.List;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.workflows.AddProtectionPolicyWorkflow;
import oracle.dbtools.extension.rcv.workflows.AddRecoveryServiceSubnetWorkflow;
import oracle.dbtools.extension.rcv.workflows.AddScheduleWorkflow;
import oracle.dbtools.extension.rcv.workflows.AddSysbackupUserWorkflow;
import oracle.dbtools.extension.rcv.workflows.BackupProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureAuthenticationWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureLogWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureProtectionPolicyWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureRMANEnvWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureRMANWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureRecoveryServiceSubnetWorkflow;
import oracle.dbtools.extension.rcv.workflows.DisableRealtimeRedoWorkflow;
import oracle.dbtools.extension.rcv.workflows.EnableRealtimeRedoWorkflow;
import oracle.dbtools.extension.rcv.workflows.RemoveOldLogsWorkflow;
import oracle.dbtools.extension.rcv.workflows.RemoveProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.RemoveProtectionPolicyWorkflow;
import oracle.dbtools.extension.rcv.workflows.RemoveRecoveryServiceSubnet;
import oracle.dbtools.extension.rcv.workflows.RemoveScheduleWorkflow;
import oracle.dbtools.extension.rcv.workflows.RunChecksWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowAuthenticationWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowChecksWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowProtectionPolicyWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowRMANConfigWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowRecoveryServiceSubnetWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowRestoreRangeWorkflow;
import oracle.dbtools.extension.rcv.workflows.ShowScheduleWorkflow;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.AddDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase.ConfigureProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.fetchtask.FetchTaskWorkflow;
import oracle.dbtools.extension.rcv.workflows.importprotecteddatabase.ImportProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public enum RCVCommandHandler {
    ADD_DATABASE(RCVCommand.SubCommand.ADD_DATABASE, AddDatabaseWorkflow.REQUIRES_CONNECTION, AddDatabaseWorkflow::new),
    ADD_PROTECTION_POLICY(RCVCommand.SubCommand.ADD_PROTECTION_POLICY, AddProtectionPolicyWorkflow.REQUIRES_CONNECTION, AddProtectionPolicyWorkflow::new),
    ADD_REALTIME_REDO(RCVCommand.SubCommand.ADD_REALTIME_REDO, EnableRealtimeRedoWorkflow.REQUIRES_CONNECTION, EnableRealtimeRedoWorkflow::new),
    ADD_RECOVERY_SERVICE_SUBNET(RCVCommand.SubCommand.ADD_RECOVERY_SERVICE_SUBNET, AddRecoveryServiceSubnetWorkflow.REQUIRES_CONNECTION, AddRecoveryServiceSubnetWorkflow::new),
    ADD_SCHEDULE(RCVCommand.SubCommand.ADD_SCHEDULE, AddScheduleWorkflow.REQUIRES_CONNECTION, AddScheduleWorkflow::new),
    ADD_SYSBACKUP_USER(RCVCommand.SubCommand.ADD_SYSBACKUP_USER, AddSysbackupUserWorkflow.REQUIRES_CONNECTION, AddSysbackupUserWorkflow::new),
    BACKUP_DATABASE(RCVCommand.SubCommand.BACKUP_DATABASE, BackupProtectedDatabaseWorkflow.REQUIRES_CONNECTION, BackupProtectedDatabaseWorkflow::new),
    CONFIGURE_AUTHENTICATION(RCVCommand.SubCommand.CONFIGURE_AUTHENTICATION, ConfigureAuthenticationWorkflow.REQUIRES_CONNECTION, ConfigureAuthenticationWorkflow::new),
    CONFIGURE_LOG(RCVCommand.SubCommand.CONFIGURE_LOG, ConfigureLogWorkflow.REQUIRES_CONNECTION, ConfigureLogWorkflow::new),
    CONFIGURE_DATABASE(RCVCommand.SubCommand.CONFIGURE_DATABASE, ConfigureProtectedDatabaseWorkflow.REQUIRES_CONNECTION, ConfigureProtectedDatabaseWorkflow::new),
    CONFIGURE_PROTECTION_POLICY(RCVCommand.SubCommand.CONFIGURE_PROTECTION_POLICY, ConfigureProtectionPolicyWorkflow.REQUIRES_CONNECTION, ConfigureProtectionPolicyWorkflow::new),
    CONFIGURE_RECOVERY_SERVICE_SUBNET(RCVCommand.SubCommand.CONFIGURE_RECOVERY_SERVICE_SUBNET, ConfigureRecoveryServiceSubnetWorkflow.REQUIRES_CONNECTION, ConfigureRecoveryServiceSubnetWorkflow::new),
    CONFIGURE_RMAN(RCVCommand.SubCommand.CONFIGURE_RMAN, ConfigureRMANWorkflow.REQUIRES_CONNECTION, ConfigureRMANWorkflow::new),
    CONFIGURE_RMAN_SCRIPT(RCVCommand.SubCommand.CONFIGURE_RMAN_ENV, ConfigureRMANEnvWorkflow.REQUIRES_CONNECTION, ConfigureRMANEnvWorkflow::new),
    CONFIGURE_SCHEDULE(RCVCommand.SubCommand.CONFIGURE_SCHEDULE, AddScheduleWorkflow.REQUIRES_CONNECTION, AddScheduleWorkflow::new),
    FETCH_TASK(RCVCommand.SubCommand.FETCH_TASK, FetchTaskWorkflow.REQUIRES_CONNECTION, FetchTaskWorkflow::new),
    FETCH_CONFIG(RCVCommand.SubCommand.FETCH_CONFIG, UpdateZRCVConfigurationWorkflow.REQUIRES_CONNECTION, UpdateZRCVConfigurationWorkflow::new),
    IMPORT_DATABASE(RCVCommand.SubCommand.IMPORT_DATABASE, ImportProtectedDatabaseWorkflow.REQUIRES_CONNECTION, ImportProtectedDatabaseWorkflow::new),
    REMOVE_DATABASE(RCVCommand.SubCommand.REMOVE_DATABASE, RemoveProtectedDatabaseWorkflow.REQUIRES_CONNECTION, RemoveProtectedDatabaseWorkflow::new),
    REMOVE_LOG(RCVCommand.SubCommand.REMOVE_LOG, RemoveOldLogsWorkflow.REQUIRES_CONNECTION, RemoveOldLogsWorkflow::new),
    REMOVE_PROTECTION_POLICY(RCVCommand.SubCommand.REMOVE_PROTECTION_POLICY, RemoveProtectionPolicyWorkflow.REQUIRES_CONNECTION, RemoveProtectionPolicyWorkflow::new),
    REMOVE_RECOVERY_SERVICE_SUBNET(RCVCommand.SubCommand.REMOVE_RECOVERY_SERVICE_SUBNET, RemoveRecoveryServiceSubnet.REQUIRES_CONNECTION, RemoveRecoveryServiceSubnet::new),
    REMOVE_REALTIME_REDO(RCVCommand.SubCommand.REMOVE_REALTIME_REDO, DisableRealtimeRedoWorkflow.REQUIRES_CONNECTION, DisableRealtimeRedoWorkflow::new),
    REMOVE_SCHEDULE(RCVCommand.SubCommand.REMOVE_SCHEDULE, RemoveScheduleWorkflow.REQUIRES_CONNECTION, RemoveScheduleWorkflow::new),
    RUN_CHECKS(RCVCommand.SubCommand.RUN_CHECKS, RunChecksWorkflow.REQUIRES_CONNECTION, RunChecksWorkflow::new),
    SHOW_AUTHENTICATION(RCVCommand.SubCommand.SHOW_AUTHENTICATION, ShowAuthenticationWorkflow.REQUIRES_CONNECTION, ShowAuthenticationWorkflow::new),
    SHOW_CHECKS(RCVCommand.SubCommand.SHOW_CHECKS, ShowChecksWorkflow.REQUIRES_CONNECTION, ShowChecksWorkflow::new),
    SHOW_DATABASE(RCVCommand.SubCommand.SHOW_DATABASE, ShowProtectedDatabaseWorkflow.REQUIRES_CONNECTION, ShowProtectedDatabaseWorkflow::new),
    SHOW_PROTECTION_POLICY(RCVCommand.SubCommand.SHOW_PROTECTION_POLICY, ShowProtectionPolicyWorkflow.REQUIRES_CONNECTION, ShowProtectionPolicyWorkflow::new),
    SHOW_RECOVERY_SERVICE_SUBNET(RCVCommand.SubCommand.SHOW_RECOVERY_SERVICE_SUBNET, ShowRecoveryServiceSubnetWorkflow.REQUIRES_CONNECTION, ShowRecoveryServiceSubnetWorkflow::new),
    SHOW_RESTORE_RANGE(RCVCommand.SubCommand.SHOW_RESTORE_RANGE, ShowRestoreRangeWorkflow.REQUIRES_CONNECTION, ShowRestoreRangeWorkflow::new),
    SHOW_SCHEDULE(RCVCommand.SubCommand.SHOW_SCHEDULE, ShowScheduleWorkflow.REQUIRES_CONNECTION, ShowScheduleWorkflow::new),
    SHOW_RMAN(RCVCommand.SubCommand.SHOW_RMAN, ShowRMANConfigWorkflow.REQUIRES_CONNECTION, ShowRMANConfigWorkflow::new);

    private RCVCommand.SubCommand subCommand;
    private boolean requiresConnection;
    private WorkflowGenerator workflowGenerator;

    private RCVCommandHandler(RCVCommand.SubCommand subCommand, boolean requiresConnection, WorkflowGenerator workflowGenerator) {
        this.subCommand = subCommand;
        this.requiresConnection = requiresConnection;
        this.workflowGenerator = workflowGenerator;
    }

    public boolean requiresConnection() {
        return this.requiresConnection;
    }

    public RCVCommand.SubCommand getSubCommand() {
        return this.subCommand;
    }

    public WorkflowGenerator getWorkflowGenerator() {
        return this.workflowGenerator;
    }

    public static RCVCommandHandler getHandler(RCVCommand.SubCommand subCommand) {
        for (RCVCommandHandler rcvCommandHandler : RCVCommandHandler.values()) {
            if (!rcvCommandHandler.subCommand.equals((Object)subCommand)) continue;
            return rcvCommandHandler;
        }
        return null;
    }

    public static RCVCommandHandler getHandler(ParsedCommand parsedCommand) {
        List tokens = parsedCommand.getTokens();
        if (tokens.size() >= 3) {
            RCVCommand.SubCommand subCommand;
            String verb = String.valueOf(tokens.get(1));
            String object = String.valueOf(tokens.get(2));
            String key = (verb + " " + object).toUpperCase();
            try {
                subCommand = RCVCommand.SubCommand.fromString(key);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            return RCVCommandHandler.getHandler(subCommand);
        }
        return null;
    }

    public static Workflow getWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        RCVCommandHandler handler = RCVCommandHandler.getHandler(command);
        if (handler == null) {
            return null;
        }
        return handler.getWorkflowGenerator().generateWorkflow(command, conn, ctx);
    }

    public static interface WorkflowGenerator {
        public Workflow generateWorkflow(ParsedCommand var1, Connection var2, ScriptRunnerContext var3);
    }
}

