/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.onboarding;

import java.sql.Connection;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class DatabaseStatusCheck
extends Check {
    public static final String ID = "db_status";
    private Connection conn;

    public DatabaseStatusCheck(Connection conn) {
        super(conn, "Database Status Check", ID);
        this.conn = conn;
    }

    @Override
    public CheckResult run() {
        String localHost;
        WorkflowLogger logger = this.getLogger();
        Map<String, String> statusMap = DatabaseUtils.getDatabaseStatusOnAllNodes(this.conn);
        if (statusMap.containsKey(localHost = DatabaseUtils.getLocalHost(this.conn))) {
            String status = statusMap.get(localHost);
            if (status.equalsIgnoreCase("OPEN")) {
                return new CheckResult(CheckResult.Status.PASS, "Local database instance is open.");
            }
            if (status.equalsIgnoreCase("MOUNTED")) {
                for (String host : statusMap.keySet()) {
                    if (host.equals(localHost) || statusMap.get(host).equalsIgnoreCase("MOUNTED")) continue;
                    logger.log(Level.FINE, "Database status: " + statusMap.toString());
                    return new CheckResult(CheckResult.Status.FAIL, "Database state is inconsistent across nodes.", "Please make sure database is either open on all nodes or mounted on all nodes.");
                }
                String message = "Database is mounted on all nodes.";
                if (statusMap.keySet().size() == 1) {
                    message = "Database is mounted.";
                }
                return new CheckResult(CheckResult.Status.PASS, message);
            }
            return new CheckResult(CheckResult.Status.FAIL, "Database is not open.", "Please make sure database is open or at least in mounted state.");
        }
        return new CheckResult(CheckResult.Status.FAIL, "Failed to get database instance on local node.");
    }
}

