/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.health;

import com.oracle.bmc.recovery.model.Health;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class BackupHealthCheck
extends Check {
    private Connection conn;
    private WorkflowLogger logger;
    public static final String NAME = "Backup Health Check";
    public static final String ID = "backup_health";

    public BackupHealthCheck(Connection conn) {
        super(conn, NAME, ID);
        this.conn = conn;
        this.logger = this.getLogger();
    }

    @Override
    public CheckResult run() {
        Database database = RCVCommandBase.getDatabase(this.conn);
        String ocid = database.getOcid();
        if (ocid != null) {
            String endpoint = database.getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
            RecoveryClientManager recoveryClientManager = new RecoveryClientManager(endpoint, this.logger.getLogger());
            ProtectedDatabase protectedDatabase = recoveryClientManager.getProtectedDatabase(ocid);
            if (protectedDatabase != null) {
                Health health = protectedDatabase.getHealth();
                if (health == null) {
                    return new CheckResult(CheckResult.Status.SKIPPED, "Cannot retrieve health information from Recovery Service because no backups have been sent yet. Please try again later.");
                }
                if (health.equals((Object)Health.Protected)) {
                    return new CheckResult(CheckResult.Status.PASS, "Backups are protected.");
                }
                if (health.equals((Object)Health.Warning)) {
                    return new CheckResult(CheckResult.Status.ALERT, protectedDatabase.getHealthDetails());
                }
                return new CheckResult(CheckResult.Status.FAIL, protectedDatabase.getHealthDetails());
            }
            String error = String.format("Failed to get information for protected database with OCID %s from the Recovery Service", ocid);
            return new CheckResult(CheckResult.Status.FAIL, error);
        }
        return new CheckResult(CheckResult.Status.SKIPPED, "Database is not onboarded to Recovery Service. Skipping Check.");
    }
}

