/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.metametadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.metametadata.Metametadata;

public class MetametadataParser {
    private static final Logger LOGGER = Logger.getLogger(MetametadataParser.class.getName());
    private Metametadata metametadata;

    public MetametadataParser(String resourceFileName) {
        ObjectMapper mapper = new ObjectMapper();
        try (InputStream input = APEXLangCompiler.class.getClassLoader().getResourceAsStream(resourceFileName);){
            ZipInputStream zipInputStream = new ZipInputStream(input);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null && !zipEntry.getName().equals("apexlangmeta/apexlang_meta_data.json")) {
                zipEntry = zipInputStream.getNextEntry();
            }
            this.metametadata = (Metametadata)mapper.readValue((InputStream)zipInputStream, Metametadata.class);
            zipInputStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed loading the Metametadata content");
            e.printStackTrace();
        }
    }

    public Metametadata getMetametadata() {
        return this.metametadata;
    }
}

