/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.apexlang.core.Range;
import oracle.apexlang.core.RawParameter;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ParsingUtil {
    private static Pattern EXTERNAL_ID_REGEX = Pattern.compile("^([^\\s]+)\\s+([^\\s]+).*$");

    public static RawParameter contentParser(TerminalNode terminalNode, String groupName) {
        Token token = terminalNode.getSymbol();
        String nodeText = terminalNode.getText();
        Integer separatorIndex = nodeText.indexOf(":");
        String key = nodeText.substring(0, separatorIndex).trim();
        String value = nodeText.substring(separatorIndex + 1, nodeText.length()).trim();
        return new RawParameter(key, value, groupName, token, false);
    }

    public static RawParameter contentParser(TerminalNode terminalNode, String groupName, boolean isArray) {
        Token token = terminalNode.getSymbol();
        String nodeText = terminalNode.getText();
        if (isArray) {
            String key = nodeText.substring(0, nodeText.indexOf(58)).trim();
            String[] tempList = nodeText.split("\n");
            CharSequence[] list = (String[])Arrays.stream(tempList, 1, tempList.length - 1).map(String::trim).toArray(String[]::new);
            String value = String.join((CharSequence)"\n", list);
            return new RawParameter(key, value, groupName, token, true);
        }
        Integer separatorIndex = nodeText.indexOf(":");
        String key = nodeText.substring(0, separatorIndex).trim();
        String value = nodeText.substring(separatorIndex + 1, nodeText.length()).trim();
        return new RawParameter(key, value, groupName, token, false);
    }

    public static String externalIDValue(String inputName) {
        String parsedName = inputName.substring(0, inputName.length()).trim();
        if (parsedName.startsWith("\"") && parsedName.endsWith("\"")) {
            parsedName = parsedName.substring(1, parsedName.length() - 1);
        }
        return parsedName;
    }

    public static Range externalIDRange(TerminalNode terminalNode) {
        return ParsingUtil.externalIDRanges(terminalNode, 0);
    }

    public static Range externalIDKeyRange(TerminalNode terminalNode) {
        return ParsingUtil.externalIDRanges(terminalNode, 1);
    }

    public static Range externalIDValueRange(TerminalNode terminalNode) {
        return ParsingUtil.externalIDRanges(terminalNode, 2);
    }

    private static Range externalIDRanges(TerminalNode terminalNode, int group) {
        Matcher m;
        Token token = terminalNode.getSymbol();
        int start = token.getStartIndex();
        int end = token.getStopIndex();
        if (group > 0 && (m = EXTERNAL_ID_REGEX.matcher(terminalNode.getText())).matches()) {
            end = start + m.end(group);
            start += m.start(group);
        }
        return new Range(start, end);
    }
}

