/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.HashMap;
import java.util.Map;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Metametadata;

public class FilePathComponentType {
    private String filePath;
    private String parentComponentTypeId;
    private Map<String, FilePathComponentType> filenameComponentTypeMap;

    public FilePathComponentType(String filePath, String parentComponentTypeId, Map<String, FilePathComponentType> filenameComponentTypeMap) {
        this.filePath = filePath;
        this.filenameComponentTypeMap = filenameComponentTypeMap;
        this.parentComponentTypeId = parentComponentTypeId;
    }

    public String getFilepath() {
        return this.filePath;
    }

    public Map<String, FilePathComponentType> getFilenameComponentTypeMap() {
        return this.filenameComponentTypeMap;
    }

    public String getParentComponentTypeId() {
        return this.parentComponentTypeId;
    }

    public static Map<String, FilePathComponentType> loadFilenameComponentTypeMap(Metametadata metametadata) {
        HashMap<String, FilePathComponentType> filenameComponentTypeMap = new HashMap<String, FilePathComponentType>();
        for (Map.Entry<String, ComponentType> componentTypeEntry : metametadata.getComponentTypes().entrySet()) {
            String parentComponentTypeId;
            ComponentType componentType = componentTypeEntry.getValue();
            String filePath = componentType.getFilePath();
            String componentTypeId = componentTypeEntry.getKey();
            String string = parentComponentTypeId = componentType.getParent() != null ? componentType.getParent().getComponentTypeId() : null;
            if (filePath == null) continue;
            if (filePath.indexOf("#ext#") >= 0) {
                filePath = filePath.replace("#ext#", APEXLangCompiler.getFileNameExtension(metametadata));
            }
            FilePathComponentType filePathComponentType = new FilePathComponentType(filePath, parentComponentTypeId, new HashMap<String, FilePathComponentType>());
            filenameComponentTypeMap.put(componentTypeId, filePathComponentType);
            if (parentComponentTypeId == null) continue;
            ((FilePathComponentType)filenameComponentTypeMap.get(parentComponentTypeId)).getFilenameComponentTypeMap().put(componentTypeId, filePathComponentType);
        }
        return filenameComponentTypeMap;
    }
}

