/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.List;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangSuggestion;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.Range;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Property;

public class ComponentParameter {
    private Component component;
    private Range range;
    private Range keyRange;
    private Range valueRange;
    private int line;
    private int column;
    private APEXLangDataType data;
    private boolean inSource;
    private boolean implicitGroup;
    private Property property;
    private Boolean pluginParameter;
    private Boolean externalIdentifier;
    private List<APEXLangSuggestion> suggestions;
    private boolean isMultilineFile;
    private ComponentType.ComponentProperty componentProperty;

    public ComponentParameter(Component component, APEXLangDataType data, Integer start, Integer propNameEnd, Integer propValueStart, Integer end, int line, int column, boolean inSource, boolean implicitGroup, Property property, Boolean pluginParameter, Boolean externalIdentifier, ComponentType.ComponentProperty componentProperty, List<APEXLangSuggestion> suggestions) {
        this.component = component;
        this.data = data;
        this.range = new Range(start, end);
        this.keyRange = new Range(start, propNameEnd);
        this.valueRange = new Range(propValueStart, end);
        this.line = line;
        this.column = column;
        this.inSource = inSource;
        this.implicitGroup = implicitGroup;
        this.property = property;
        this.pluginParameter = pluginParameter;
        this.externalIdentifier = externalIdentifier;
        this.suggestions = suggestions;
        this.componentProperty = componentProperty;
    }

    public ComponentParameter(Component component, APEXLangDataType data, Integer start, Integer propNameEnd, Integer propValueStart, Integer end, int line, int column, boolean inSource, boolean implicitGroup, Property property, Boolean pluginParameter, Boolean externalIdentifier, ComponentType.ComponentProperty componentProperty, List<APEXLangSuggestion> suggestions, boolean isMultilineFile) {
        this(component, data, start, propNameEnd, propValueStart, end, line, column, inSource, implicitGroup, property, pluginParameter, externalIdentifier, componentProperty, suggestions);
        this.isMultilineFile = isMultilineFile;
    }

    public ComponentType.ComponentProperty getComponentProperty() {
        return this.componentProperty;
    }

    public String getScope() {
        return this.componentProperty.getLov() != null ? this.componentProperty.getLov().getScope() : null;
    }

    public ComponentType.DependingOn getFilter() {
        if (this.componentProperty.getLov().getScope() != null) {
            return this.componentProperty.getLov().getFilter();
        }
        return null;
    }

    public Boolean isExternalIdentifier() {
        return this.externalIdentifier;
    }

    public Boolean isPluginParameter() {
        return this.pluginParameter;
    }

    public Property getProperty() {
        return this.property;
    }

    public Component getComponent() {
        return this.component;
    }

    public APEXLangDataType getData() {
        return this.data;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public String getValue() {
        return this.data.toString();
    }

    public Range getRange() {
        return this.range;
    }

    public Range getKeyRange() {
        return this.keyRange;
    }

    public Range getValueRange() {
        return this.valueRange;
    }

    public String getExpression() {
        return this.componentProperty.getApiParameter() != null ? this.componentProperty.getApiParameter().getExpression() : "";
    }

    public String generatePlSQLCode() {
        if (this.isDeprecated()) {
            return "";
        }
        String plsql = this.getExpression();
        String bindVariable = ":value";
        if (this.pluginParameter.booleanValue()) {
            bindVariable = ":plugin_attribute_expression";
        }
        plsql = this.getData().toPlSql(plsql, bindVariable);
        return plsql;
    }

    private boolean isDeprecated() {
        boolean isDeprecated = false;
        if (this.property.getDeprecatedValues() == null) {
            return isDeprecated;
        }
        if (!this.inSource) {
            for (String deprecatedValue : this.property.getDeprecatedValues()) {
                if (!deprecatedValue.equals("$NOT_NULL$")) continue;
                isDeprecated = true;
            }
        }
        for (String deprecatedValue : this.property.getDeprecatedValues()) {
            if (!this.data.toString().equals(deprecatedValue)) continue;
            isDeprecated = true;
        }
        return isDeprecated;
    }

    public boolean isInSource() {
        return this.inSource;
    }

    public boolean isImplicitGroup() {
        return this.implicitGroup;
    }

    public List<APEXLangSuggestion> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(List<APEXLangSuggestion> suggestions) {
        this.suggestions = suggestions;
    }

    public boolean isMultilineFile() {
        return this.isMultilineFile;
    }

    public void setMultilineFile(boolean isMultilineFile) {
        this.isMultilineFile = isMultilineFile;
    }
}

