/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.apexlang.APEXAppFile;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.metametadata.Plugins;

public class APEXLangNativePluginsLoader {
    private Map<String, APEXAppFile> source;
    private Map<String, Map<String, Component>> pluginTypesMap;
    private Map<Component, List<Component>> pluginsChildren;
    private Map<String, Map<String, Map<String, Component>>> centralThemePluginTypesMapPerAppId;
    private static final Logger LOGGER = Logger.getLogger(APEXLangNativePluginsLoader.class.getName());

    public APEXLangNativePluginsLoader(APEXLangCompiler compiler, Map<String, APEXAppFile> nativePluginsSourceCode, Map<String, Map<String, APEXAppFile>> centralThemeApps) {
        this.source = nativePluginsSourceCode;
        this.pluginTypesMap = new HashMap<String, Map<String, Component>>();
        this.pluginsChildren = new HashMap<Component, List<Component>>();
        this.centralThemePluginTypesMapPerAppId = new HashMap<String, Map<String, Map<String, Component>>>();
        this.compileCentralThemePlugins(compiler, centralThemeApps);
        this.compileNativePlugins(compiler);
    }

    private void compileCentralThemePlugins(APEXLangCompiler compiler, Map<String, Map<String, APEXAppFile>> centralThemeApps) {
        Plugins plugins = compiler.getMetametadata().getPlugins();
        for (String key : centralThemeApps.keySet()) {
            Map<String, APEXAppFile> fileMap = centralThemeApps.get(key);
            APEXLangCompilationResult result = compiler.compile(fileMap, new APEXLangCompilerContext());
            for (Component component : result.getComponentsParameters()) {
                ComponentParameter typePropertyId;
                this.pluginsChildren.put(component, new ArrayList());
                if (this.pluginsChildren.get(component.getParent()) != null) {
                    this.pluginsChildren.get(component.getParent()).add(component);
                }
                if (!component.getTypeId().equals(plugins.getComponentTypeId()) || (typePropertyId = component.getParameters().get(plugins.getTypePropertyId())) == null) continue;
                if (this.centralThemePluginTypesMapPerAppId.get(key) == null) {
                    this.centralThemePluginTypesMapPerAppId.put(key, new HashMap());
                }
                String pluginType = typePropertyId.getValue();
                if (this.centralThemePluginTypesMapPerAppId.get(key).get(pluginType) == null) {
                    this.centralThemePluginTypesMapPerAppId.get(key).put(pluginType, new HashMap());
                }
                String pluginName = component.getParameters().get(plugins.getApexLangNamePropertyId()).getValue();
                this.centralThemePluginTypesMapPerAppId.get(key).get(pluginType).put(pluginName, component);
            }
        }
    }

    private void compileNativePlugins(APEXLangCompiler compiler) {
        Plugins plugins = compiler.getMetametadata().getPlugins();
        APEXLangCompilationResult result = compiler.compile(this.source, new APEXLangCompilerContext());
        for (Component component : result.getComponentsParameters()) {
            ComponentParameter typePropertyId;
            this.pluginsChildren.put(component, new ArrayList());
            if (this.pluginsChildren.get(component.getParent()) != null) {
                this.pluginsChildren.get(component.getParent()).add(component);
            }
            if (!component.getTypeId().equals(plugins.getComponentTypeId()) || (typePropertyId = component.getParameters().get(plugins.getTypePropertyId())) == null) continue;
            String pluginType = typePropertyId.getValue();
            if (this.pluginTypesMap.get(pluginType) == null) {
                this.pluginTypesMap.put(pluginType, new HashMap());
            }
            String pluginName = component.getParameters().get(plugins.getApexLangNamePropertyId()).getValue();
            this.pluginTypesMap.get(pluginType).put(pluginName, component);
        }
    }

    public Map<String, Map<String, Map<String, Component>>> getCentralThemePluginTypesMapPerAppId() {
        return this.centralThemePluginTypesMapPerAppId;
    }

    public Map<String, APEXAppFile> getSource() {
        return this.source;
    }

    public Map<String, Map<String, Component>> getPluginTypesMap() {
        return this.pluginTypesMap;
    }

    public Map<Component, List<Component>> getPluginsChildren() {
        return this.pluginsChildren;
    }
}

