/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangValidationException;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;

public class APEXLangDateDataType
extends APEXLangDataType {
    private String outputType;

    public APEXLangDateDataType(String data, String outputType) {
        super(data);
        this.outputType = outputType;
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        return Transpiler.replaceAllSafely(template, bindVariable, Transpiler.replaceAllSafely("to_date(':dateValue', 'YYYY-MM-DD\"T\"HH24:MI:SS')", ":dateValue", this.data));
    }

    @Override
    protected void validateImpl(Property property, PropertyType propertyType) throws APEXLangValidationException {
        try {
            LocalDate.parse(this.data, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new APEXLangValidationException("Invalid date: " + this.data + " Example of valid format is 2011-12-03T10:15:30");
        }
    }

    public String toString() {
        return this.data;
    }
}

