/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class APEXAppFile {
    private byte[] contentBytes;

    public APEXAppFile() {
    }

    public APEXAppFile(byte[] bytes) {
        this.contentBytes = bytes;
    }

    public APEXAppFile(String content) {
        if (content != null) {
            this.contentBytes = content.getBytes();
        }
    }

    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    protected void setContentBytes(byte[] bytes) {
        this.contentBytes = bytes;
    }

    public String toString() {
        return this.getContentString();
    }

    public String getContentString() {
        if (this.contentBytes == null) {
            return null;
        }
        return new String(this.contentBytes, StandardCharsets.UTF_8);
    }

    public void setContentString(String contentString) {
        this.contentBytes = (byte[])(contentString != null ? contentString.getBytes() : null);
    }

    public String getContentString(Charset charset) {
        return new String(this.contentBytes, charset);
    }

    public String getContentHex() {
        if (this.contentBytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : this.contentBytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    protected void setContentHex(String hexString) {
        if (hexString == null || ((String)hexString).isEmpty()) {
            this.contentBytes = new byte[0];
            return;
        }
        if (((String)hexString).length() % 2 != 0) {
            hexString = "0" + (String)hexString;
            return;
        }
        byte[] rawBytes = new byte[((String)hexString).length() / 2];
        for (int i = 0; i < ((String)hexString).length(); i += 2) {
            String byteString = ((String)hexString).substring(i, i + 2);
            rawBytes[i / 2] = (byte)Integer.parseInt(byteString, 16);
        }
        this.contentBytes = rawBytes;
    }
}

