/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.oracle.SchemaDDLGenerator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.model.persistence.LogicalDataTypesReader;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.jdv.dbimport.DBMExtractionHandlerJDV;
import oracle.dbtools.jdv.dbimport.MOHJDViewHandler;
import oracle.dbtools.jdv.dbimport.Transform;
import oracle.dbtools.jdv.ddl.GqlGenerator;
import oracle.dbtools.jdv.ddl.SqlGenerator;
import oracle.dbtools.jdv.model.JDVView;
import oracle.dbtools.modeler.SdnRequestWrapper;

public class JDVUtil {
    public static final String TYPE_OF_OBJECT = "typeOfObject";
    public static final String OBJECT_OWNER = "objectOwner";
    public static final String OBJECT_NAME = "objectName";
    public static final String OBJECTS_DETAILS_QUERY = "OBJECTS_DETAILS_QUERY";
    public static final String OBJECTS_DETAILS_RESULT = "OBJECTS_DETAILS_RESULT";
    public static final String DUALITY_VIEW = "DUALITY_VIEW";
    public static final String INCLUDE_SCHEMA = "includeSchema";
    public static final String JDV_CONTEXT = "JDV_CONTEXT";
    public static final String JDV_JSON_SCHEMA = "JDV_JSON_SCHEMA";
    public static final String FORMAT = "format";
    public static final String GQL = "gql";
    public static final String DDL = "ddl";
    public static final String GQL_QUERY = "gql_query";
    public static final String SQL_QUERY = "ddl_query";
    public static final String TRUE = "true";

    public static String getJDViewJson(Connection conn, String owner, String name) throws SQLException, IOException {
        DBMExtractionHandlerJDV eh = new DBMExtractionHandlerJDV(conn);
        JDVView view = eh.getJDVView(conn, owner, name);
        return view.toJSONString(true);
    }

    public static String getJDVViewAndUsedTablesDetails(Connection conn, String schema, String name) throws SQLException, IOException {
        DBMExtractionHandlerJDV eh = new DBMExtractionHandlerJDV(conn);
        return eh.getJDVViewAndUsedTablesDetails(conn, schema, name);
    }

    public static String getJDV_JSON_Schema(Connection conn, String schema, String name) throws SQLException, IOException {
        DBMExtractionHandlerJDV eh = new DBMExtractionHandlerJDV(conn);
        MOHJDViewHandler moh = new MOHJDViewHandler(eh);
        return moh.getJsonSchemaWithOrder(conn, schema, name);
    }

    public String getObjectsDetailsResult(Connection conn, String json) throws SQLException, IOException {
        return JDVUtil.getObjectDetailsQueryResult(conn, json);
    }

    public static Design getDesign() {
        Design des = new Design();
        LogicalDataTypesReader lr = new LogicalDataTypesReader();
        lr.recreateLogicalTypes(des);
        RelationalDesign relModel = des.addRelationalDesign();
        des.setRelationalDesign(relModel);
        des.setPropagatePKChahges(false);
        des.setImporting(true);
        des.setLoading(true);
        Settings settings = des.getSettings();
        settings.setImportPartitions(false);
        settings.setImportSecondaryTables(false);
        settings.setImportColumnDetails(false);
        settings.setImportSpatialProperties(false);
        settings.setImportTriggers(false);
        settings.setScanForUsedStructuredTypes(false);
        settings.setIncludeDefaultSettingsInDDL(false);
        settings.setIncludeStorageInDDL(false);
        settings.setIncludeTablespaceInDDL(false);
        settings.setIncludeLoggingInDDL(false);
        settings.setImportCommentsInRDBMS(true);
        return des;
    }

    public static String getObjectDetails(Connection conn, SdnRequestWrapper wrapper) throws SQLException, IOException {
        boolean valid;
        String typeOfObject = wrapper.getProperty(TYPE_OF_OBJECT);
        String objectOwner = wrapper.getProperty(OBJECT_OWNER);
        String objectName = wrapper.getProperty(OBJECT_NAME);
        boolean bl = valid = objectOwner != null && objectName != null && !objectOwner.isEmpty() && !objectName.isEmpty();
        if (valid) {
            if (DUALITY_VIEW.equals(typeOfObject)) {
                return JDVUtil.getJDViewJson(conn, objectOwner, objectName);
            }
            if (JDV_CONTEXT.equals(typeOfObject)) {
                return JDVUtil.getJDVViewAndUsedTablesDetails(conn, objectOwner, objectName);
            }
            if (JDV_JSON_SCHEMA.equals(typeOfObject)) {
                return JDVUtil.getJDV_JSON_Schema(conn, objectOwner, objectName);
            }
        }
        return "";
    }

    static List<Table> getDetailsForObjects(Connection conn, String json) throws SQLException {
        ArrayList<Table> res = new ArrayList<Table>();
        Design.dmInternalsDistDir = SchemaDDLGenerator.webPath;
        MetaFileLoader.DMWEB = true;
        Design des = JDVUtil.getDesign();
        RelationalDesign relModel = des.getRelationalDesign();
        DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
        handler.init(conn);
        relModel.setSelectedRDBMSSite(handler.getRDBMSSite());
        StorageDesign sd = relModel.getStorageDesign();
        sd.openStorageDesign();
        List<DBObject> objects = JDVUtil.getObjectsToImport(json);
        ImportLogger importLog = new ImportLogger();
        handler.generateDesign(conn, objects, importLog);
        TableSet ts = relModel.getTableSet();
        for (int i = 0; i < ts.size(); ++i) {
            Table t = (Table)ts.getElement(i);
            res.add(t);
        }
        return res;
    }

    public static String getObjectDetailsQueryResult(Connection conn, String json) throws IOException, SQLException {
        List<Table> list = JDVUtil.getDetailsForObjects(conn, json);
        if (list.size() > 0) {
            Object res = "{\"objectType\":\"OBJECTS_DETAILS_RESULT\"";
            res = (String)res + ",\n\"items\":" + Transform.getUsedTablesAsJSONArray(list) + "\n}";
            return res;
        }
        return "{}";
    }

    public static List<DBObject> getObjectsToImport(String json) {
        JsonArray items;
        ArrayList<DBObject> res = new ArrayList<DBObject>();
        ByteArrayInputStream stream = null;
        JsonObject jdoc = null;
        stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        jdoc = Json.createReader((InputStream)stream).readObject();
        if (jdoc != null && (items = jdoc.getJsonArray("items")) != null) {
            for (JsonValue val : items) {
                if (!(val instanceof JsonObject)) continue;
                JsonObject item = (JsonObject)val;
                String type = item.getString("objectType", null);
                String owner = item.getString("owner", null);
                String name = item.getString("name", null);
                if (owner == null || name == null || type == null) continue;
                res.add(new DBObject(true, name, type, owner));
            }
        }
        return res;
    }

    public static String getDualityViewDDL(Connection connection, String json, boolean queryOnly, boolean checkMixedCase) {
        return SqlGenerator.getViewDefinition(json, false, true, queryOnly, checkMixedCase);
    }

    public static String getDualityViewDDL(Connection connection, SdnRequestWrapper wrapper) throws SQLException, IOException {
        String typeOfObject = wrapper.getProperty(TYPE_OF_OBJECT);
        String objectOwner = wrapper.getProperty(OBJECT_OWNER);
        String objectName = wrapper.getProperty(OBJECT_NAME);
        String includeSchema = wrapper.getProperty(INCLUDE_SCHEMA);
        boolean queryOnly = true;
        boolean checkMixedCase = false;
        if (DUALITY_VIEW.equals(typeOfObject)) {
            boolean update = objectOwner != null && objectName != null && !objectOwner.isEmpty() && !objectName.isEmpty();
            boolean inclSchema = TRUE.equalsIgnoreCase(includeSchema);
            String format = wrapper.getProperty(FORMAT);
            if (format == null || GQL.equalsIgnoreCase(format)) {
                return GqlGenerator.getViewDefinition(wrapper.getRequestBody(), update, inclSchema);
            }
            if (DDL.equalsIgnoreCase(format)) {
                return SqlGenerator.getViewDefinition(wrapper.getRequestBody(), update, inclSchema);
            }
            if (SQL_QUERY.equalsIgnoreCase(format)) {
                return SqlGenerator.getViewDefinition(wrapper.getRequestBody(), update, inclSchema, true, false);
            }
            if (GQL_QUERY.equalsIgnoreCase(format)) {
                return GqlGenerator.getViewDefinition(wrapper.getRequestBody(), update, inclSchema, true, false);
            }
        }
        return "";
    }
}

