/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomReportTemplatesPersistence {
    public static final String RT_FILE_NAME = "custom_report_templates.xml";
    private static final Logger LOGGER = new Logger(CustomReportTemplatesPersistence.class);

    public static List<CustomReportTemplate> loadCustomReportTemplates() {
        ArrayList<CustomReportTemplate> loadedCustomReportTemplates = new ArrayList<CustomReportTemplate>();
        try {
            File file;
            File dir;
            if (Design.systemTypesDir != null && (dir = new File(Design.systemTypesDir)).exists() && (file = new File(dir, RT_FILE_NAME)).exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                CustomReportTemplatesPersistence.loadData(doc, loadedCustomReportTemplates);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load custom report templates: ", e);
        }
        return loadedCustomReportTemplates;
    }

    private static void loadData(Document doc, List<CustomReportTemplate> loadedCustomReportTemplates) {
        try {
            Element dataElement = (Element)doc.getElementsByTagName("data").item(0);
            String fileVersion = dataElement.getAttribute("version");
            NodeList nodes = doc.getElementsByTagName("custom_report_template");
            int nodesLength0 = nodes.getLength();
            MetaDataManager metaDataManager = XMLTransformationManager.getInstance().getMetaDataManager();
            if (fileVersion.equals("1.0")) {
                for (int i = 0; i < nodesLength0; ++i) {
                    Element elm = (Element)nodes.item(i);
                    String crtName = elm.getAttribute("name");
                    String className = elm.getAttribute("class");
                    if (!className.equals("")) {
                        Class<?> clazz;
                        if (className.startsWith("oracle.dbtools.crest.model.design.multidimensional") || (clazz = Class.forName(className = className.replaceAll("oracle.dbtools.crest.model", "oracle.dbtools.crest.jsmodel"))) == null) continue;
                        CustomReportTemplate crt = new CustomReportTemplate(StringUtilities.decodeAttributeValue(elm.getAttribute("name")), clazz, StringUtilities.decodeAttributeValue(elm.getAttribute("description")), elm.getAttribute("id"));
                        ClassDescription cd = metaDataManager.getClassDescription(className);
                        NodeList nodes1 = elm.getElementsByTagName("sections");
                        int nodesLength = nodes1.getLength();
                        for (int j = 0; j < nodesLength; ++j) {
                            Element e = (Element)nodes1.item(j);
                            NodeList elements = e.getElementsByTagName("section");
                            int elementsLength = elements.getLength();
                            for (int k = 0; k < elementsLength; ++k) {
                                Element e1 = (Element)elements.item(k);
                                String sPropertyName = StringUtilities.decodeAttributeValue(e1.getAttribute("propertyName"));
                                String sPropertyType = e1.getAttribute("type");
                                String sCustomName = StringUtilities.decodeAttributeValue(e1.getAttribute("customName"));
                                int sLevel = Integer.parseInt(e1.getAttribute("level"));
                                Object element = null;
                                element = sPropertyType.equals("collection") ? cd.getCollectionDescriptionByName(sPropertyName) : (sPropertyType.equals("roPropertiesList") ? cd.getROPropertyDescriptionByName(sPropertyName) : metaDataManager.getClassDescription(className));
                                ReportSection rs = new ReportSection(element, sPropertyName, sCustomName, sLevel, sPropertyType);
                                crt.getReportSections().add(rs);
                                NodeList nodes2 = e1.getElementsByTagName("columns");
                                int nodesLength2 = nodes2.getLength();
                                for (int c = 0; c < nodesLength2; ++c) {
                                    Element e2 = (Element)nodes2.item(c);
                                    NodeList elements2 = e2.getElementsByTagName("column");
                                    int elementsLength2 = elements2.getLength();
                                    for (int d = 0; d < elementsLength2; ++d) {
                                        Element e3 = (Element)elements2.item(d);
                                        String cName = StringUtilities.decodeAttributeValue(e3.getAttribute("name"));
                                        String cCustomName = StringUtilities.decodeAttributeValue(e3.getAttribute("customName"));
                                        String cOrder = e3.getAttribute("order");
                                        double cSize = Double.parseDouble(e3.getAttribute("width"));
                                        boolean cMassUpdatable = Boolean.valueOf(e3.getAttribute("massUpdatable"));
                                        boolean isDynamicProperty = Boolean.valueOf(e3.getAttribute("dynamic"));
                                        boolean isUDPProperty = Boolean.valueOf(e1.getAttribute("udp"));
                                        ReportColumn rColumn = new ReportColumn(cName, cCustomName, cSize, "", cOrder, cMassUpdatable, isDynamicProperty, isUDPProperty);
                                        rs.getReportColumns().add(rColumn);
                                    }
                                }
                            }
                        }
                        loadedCustomReportTemplates.add(crt);
                        continue;
                    }
                    LOGGER.error("Class name not found for custom report template " + crtName + ". Template can not be loaded.");
                }
            } else if (fileVersion.equals("")) {
                for (int i = 0; i < nodesLength0; ++i) {
                    Class<?> clazz;
                    Element elm = (Element)nodes.item(i);
                    String className = elm.getAttribute("class");
                    if (className.equals("") || className.startsWith("oracle.dbtools.crest.model.design.multidimensional") || (clazz = Class.forName(className = className.replaceAll("oracle.dbtools.crest.model", "oracle.dbtools.crest.jsmodel"))) == null) continue;
                    CustomReportTemplate crt = new CustomReportTemplate(StringUtilities.decodeAttributeValue(elm.getAttribute("name")), clazz, StringUtilities.decodeAttributeValue(elm.getAttribute("description")), elm.getAttribute("id"));
                    ClassDescription element = metaDataManager.getClassDescription(className);
                    String sPropertyName = element.getXmlName();
                    ReportSection rs = new ReportSection(element, sPropertyName, "", 0, "");
                    crt.getReportSections().add(rs);
                    NodeList nodes1 = elm.getElementsByTagName("properties");
                    int nodesLength = nodes1.getLength();
                    for (int j = 0; j < nodesLength; ++j) {
                        Element e = (Element)nodes1.item(j);
                        NodeList elements = e.getElementsByTagName("property");
                        int elementsLength = elements.getLength();
                        for (int k = 0; k < elementsLength; ++k) {
                            Element e1 = (Element)elements.item(k);
                            String cName = e1.getAttribute("name");
                            String cCustomName = e1.getAttribute("customName");
                            String cOrder = e1.getAttribute("order");
                            int cSize = Integer.parseInt(e1.getAttribute("width"));
                            boolean cMassUpdatable = Boolean.valueOf(e1.getAttribute("massUpdatable"));
                            boolean isDynamicProperty = Boolean.valueOf(e1.getAttribute("dynamic"));
                            boolean isUDPProperty = Boolean.valueOf(e1.getAttribute("udp"));
                            ReportColumn rColumn = new ReportColumn(cName, cCustomName, cSize, "", cOrder, cMassUpdatable, isDynamicProperty, isUDPProperty);
                            rs.getReportColumns().add(rColumn);
                        }
                    }
                    loadedCustomReportTemplates.add(crt);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load custom report templates: ", e);
        }
    }
}

