/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling.compare;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;

public class ArgumentsCollectionCompare {
    List<SchedulerObjectCompare> list = new ArrayList<SchedulerObjectCompare>();
    List<SchedulerArgument> source;
    List<SchedulerArgument> target;
    List<SchedulerArgument> toRemove = new ArrayList<SchedulerArgument>();
    List<SchedulerArgument> toAdd = new ArrayList<SchedulerArgument>();

    public ArgumentsCollectionCompare(List<SchedulerArgument> source, List<SchedulerArgument> target) {
        this.source = source;
        this.target = target;
        this.scan();
    }

    void scan() {
        this.processToRemove();
        this.processToAdd();
    }

    void addToList(List<SchedulerArgument> list, SchedulerArgument arg) {
        if (!list.contains(arg)) {
            list.add(arg);
        }
    }

    void processToRemove() {
        if (this.source.size() == 0) {
            this.toRemove.addAll(this.target);
            return;
        }
        for (SchedulerArgument arg : this.target) {
            SchedulerArgument s = this.getArgumentByPosition(this.source, arg.getPosition());
            if (s != null) continue;
            this.toRemove.add(arg);
        }
    }

    void processToAdd() {
        if (this.target.size() == 0) {
            this.toAdd.addAll(this.source);
            return;
        }
        for (SchedulerArgument arg : this.source) {
            SchedulerArgument s = this.getArgumentByPosition(this.target, arg.getPosition());
            if (s == null) {
                this.toAdd.add(arg);
                continue;
            }
            SchedulerObjectCompare comp = new SchedulerObjectCompare(arg, s);
            if (!comp.isModified()) continue;
            this.toAdd.add(arg);
        }
    }

    public SchedulerArgument getArgumentByPosition(List<SchedulerArgument> args, int position) {
        for (SchedulerArgument arg : args) {
            if (position != arg.getPosition()) continue;
            return arg;
        }
        return null;
    }

    public List<SchedulerArgument> getToRemove() {
        return this.toRemove;
    }

    public List<SchedulerArgument> getToAdd() {
        return this.toAdd;
    }

    public boolean isModified() {
        return this.toRemove.size() > 0 || this.toAdd.size() > 0;
    }
}

