/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import java.util.Arrays;
import java.util.List;
import oracle.dbtools.crest.model.scheduling.Positioned;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerArgument
extends SchedulerObject
implements Positioned {
    String[] metadataAttributes = new String[]{"JOB_OWNER", "JOB_NAME", "JOB_SUBNAME", "JOB_START", "JOB_SCHEDULED_START", "EVENT_MESSAGE", "WINDOW_START", "WINDOW_END"};
    List<String> meta = Arrays.asList(this.metadataAttributes);

    @Override
    public void initPropsList() {
        this.propsList.add("ARGUMENT_NAME");
        this.propsList.add("ARGUMENT_POSITION");
        this.propsList.add("ARGUMENT_TYPE");
        this.propsList.add("METADATA_ATTRIBUTE");
        this.propsList.add("DEFAULT_VALUE");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("ARGUMENT_NAME", "VARCHAR2");
        this.dataTypes.put("ARGUMENT_POSITION", "NUMBER");
        this.dataTypes.put("ARGUMENT_TYPE", "VARCHAR2");
        this.dataTypes.put("METADATA_ATTRIBUTE", "VARCHAR2");
        this.dataTypes.put("DEFAULT_VALUE", "VARCHAR2");
        this.dataTypes.put("DEFAULT_ANYDATA_VALUE", "ANYDATA");
    }

    @Override
    public void initdefaults() {
    }

    @Override
    public String getName() {
        return this.getProperty("ARGUMENT_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String pos = this.getProperty("ARGUMENT_POSITION");
        if (pos != null && !pos.isEmpty()) {
            try {
                int i = Integer.parseInt(pos);
                if (i > 0) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int getPosition() {
        String pos = this.getProperty("ARGUMENT_POSITION");
        if (pos != null && !pos.isEmpty()) {
            try {
                return Integer.parseInt(pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean isMetadataArgument() {
        String val = this.getProperty("METADATA_ATTRIBUTE");
        if (val != null && !val.isEmpty()) {
            return this.meta.contains(val.toUpperCase());
        }
        return false;
    }
}

