/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public abstract class DataBaseOracle
extends StorageObject
implements ModelObjectSetListener,
StorageObjectListener {
    private String controlFileReuse = "YES";
    private int maxLogFiles = 1;
    private int maxLogMembers = 1;
    private int maxLogHistory = 0;
    private int maxDataFiles = 10;
    private int maxInstances = 1;
    private String archiveLog = "YES";
    private String characterSet = "";
    private String nationalCharacterSet = "";
    protected StorageObjectCollection dfiles;
    protected StorageObjectCollection rlgroups;
    protected StorageObjectCollection sysAuxFiles;
    public static final String TYPE_NAME = "DB";
    public static final String OLD_TYPE_NAME = "DataBaseOracle";

    public DataBaseOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.dfiles = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getDataFileSet());
        this.rlgroups = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getRedoLogGroupSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setDataBase");
        this.dfiles.setClassForParent(DataBaseOracle.class);
        this.rlgroups.setParent(this);
        this.rlgroups.setName(Messages.getString("DataBaseOracle.RedoLogGroups"));
        this.rlgroups.setSetMethod("setDataBase");
        this.rlgroups.setClassForParent(DataBaseOracle.class);
        ((StorageDesignOracle)storageDesign).getRedoLogGroupSet().addSetListener(this);
        ((StorageDesignOracle)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public String getIDPrefix() {
        return "DBO";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public void setControlFileReuse(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.controlFileReuse = value;
            this.fireDataFieldChange();
        }
    }

    public String getControlFileReuse() {
        return this.controlFileReuse;
    }

    public void setMaxLogFiles(int maxLogFiles) {
        this.maxLogFiles = maxLogFiles;
        this.fireDataFieldChange();
    }

    public int getMaxLogFiles() {
        return this.maxLogFiles;
    }

    public void setMaxLogMembers(int maxLogMembers) {
        this.maxLogMembers = maxLogMembers;
        this.fireDataFieldChange();
    }

    public int getMaxLogMembers() {
        return this.maxLogMembers;
    }

    public void setMaxLogHistory(int maxLogHistory) {
        this.maxLogHistory = maxLogHistory;
        this.fireDataFieldChange();
    }

    public int getMaxLogHistory() {
        return this.maxLogHistory;
    }

    public void setMaxDataFiles(int maxDataFiles) {
        this.maxDataFiles = maxDataFiles;
        this.fireDataFieldChange();
    }

    public int getMaxDataFiles() {
        return this.maxDataFiles;
    }

    public void setMaxInstances(int maxInstances) {
        this.maxInstances = maxInstances;
        this.fireDataFieldChange();
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setArchiveLog(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.archiveLog = value;
            this.fireDataFieldChange();
        }
    }

    public String getArchiveLog() {
        return this.archiveLog;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        this.fireDataFieldChange();
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setNationalCharacterSet(String nationalCharacterSet) {
        this.nationalCharacterSet = nationalCharacterSet;
        this.fireDataFieldChange();
    }

    public String getNationalCharacterSet() {
        return this.nationalCharacterSet;
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.dfiles;
            }
            case 1: {
                return this.rlgroups;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.dfiles) {
            return 0;
        }
        if (child == this.rlgroups) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.dfiles) {
            return 0;
        }
        if (child == this.rlgroups) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.dfiles.removeAll();
        this.rlgroups.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof DataFileOracle) {
                DataFileOracle df = (DataFileOracle)event.getAffected();
                df.addObjectListener(this);
                if (df.getDataBase() != null && df.getDataBase() == this) {
                    df.setParent(this.dfiles);
                    this.dfiles.add(df);
                } else {
                    this.dfiles.remove(df);
                }
            } else if (event.getAffected() instanceof RedoLogGroupOracle) {
                RedoLogGroupOracle rlg = (RedoLogGroupOracle)event.getAffected();
                rlg.addObjectListener(this);
                if (rlg.getDataBase() != null && rlg.getDataBase() == this) {
                    rlg.setParent(this.rlgroups);
                    this.rlgroups.add(rlg);
                } else {
                    this.rlgroups.remove(rlg);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof DataFileOracle) {
                DataFileOracle df = (DataFileOracle)event.getAffected();
                this.dfiles.remove(df);
                df.removeObjectListener(this);
            } else if (event.getAffected() instanceof RedoLogGroupOracle) {
                RedoLogGroupOracle rlg = (RedoLogGroupOracle)event.getAffected();
                this.rlgroups.remove(rlg);
                rlg.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof DataFileOracle) {
            DataFileOracle df = (DataFileOracle)event.getAffected();
            if (df.getDataBase() != null && df.getDataBase() == this) {
                df.setParent(this.dfiles);
                this.dfiles.add(df);
            } else {
                this.dfiles.remove(df);
            }
        } else if (event.getAffected() instanceof RedoLogGroupOracle) {
            RedoLogGroupOracle rlg = (RedoLogGroupOracle)event.getAffected();
            if (rlg.getDataBase() != null && rlg.getDataBase() == this) {
                rlg.setParent(this.rlgroups);
                this.rlgroups.add(rlg);
            } else {
                this.rlgroups.remove(rlg);
            }
        }
    }

    public List getDataFiles() {
        ArrayList list = new ArrayList();
        this.dfiles.addAllElementsTo(list);
        return list;
    }

    public List getRedoLogGroups() {
        ArrayList list = new ArrayList();
        this.rlgroups.addAllElementsTo(list);
        return list;
    }

    public StorageObjectCollection getDataFileCollection() {
        return this.dfiles;
    }

    public DataFileOracle createDataFile() {
        if (this.dfiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.dfiles.createElement(null);
        }
        return null;
    }

    public StorageObjectCollection getRedoLogGroupCollection() {
        return this.rlgroups;
    }

    public RedoLogGroupOracle createRedoLogGroup() {
        if (this.rlgroups.getStorageObjectSet() != null) {
            return (RedoLogGroupOracle)this.rlgroups.createElement(null);
        }
        return null;
    }

    @Override
    public void clearNoneMergableStructure() {
        this.rlgroups.removeAll();
        this.dfiles.removeAll();
        if (this.sysAuxFiles != null) {
            this.sysAuxFiles.removeAll();
        }
    }
}

