/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;

public class ColumnProxySetOracle
extends ColumnProxySet {
    public ColumnProxySetOracle(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new ColumnProxyOracle((Column)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new ColumnProxyOracle(design, id, longName, this.getStorageDesign());
    }

    @Override
    public void doAfterAdd(RelationalObjectProxy addedProxy) {
        ColumnProxyOracle proxy = (ColumnProxyOracle)addedProxy;
        Column column = (Column)proxy.getObject();
        String defaultValue = proxy.getDefaultValue();
        if (defaultValue == null || defaultValue.equals("")) {
            proxy.setDefaultValue(column.getDefaultValue());
        }
        if (addedProxy instanceof ColumnProxyOracle) {
            // empty if block
        }
    }

    public ColumnProxyOracle getByLongName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ColumnProxyOracle tpo = (ColumnProxyOracle)it.next();
            if (!name.equalsIgnoreCase(tpo.getLongName())) continue;
            return tpo;
        }
        return null;
    }

    @Override
    public ColumnProxyOracle getByName(String name) {
        if (name.startsWith("\"")) {
            name = name.replaceAll("\"", "");
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ColumnProxyOracle cpo = (ColumnProxyOracle)it.next();
            String cpoName = cpo.getName();
            if (!name.equalsIgnoreCase(cpoName)) continue;
            if (cpo.getNameHasQuotes()) {
                if (!name.equals(cpoName) && !name.toUpperCase().equals(cpoName)) continue;
                return cpo;
            }
            return cpo;
        }
        return null;
    }
}

