/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;

public class StorageObjectPropertyTranslator
implements PropertyTranslator {
    public static final String NO_OBJECT = "NO_OBJECT";
    Class storageObjectClass = StorageObject.class;
    private StorageDesign storageDesign;

    public StorageObjectPropertyTranslator(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public Object translateFromString(String id) {
        if (id == null || NO_OBJECT.equals(id)) {
            return null;
        }
        StorageObject result = this.storageDesign.getStorageObject(id);
        if (result == null) {
            ModelIDObject obj;
            String newID = null;
            Map map = this.storageDesign.getCorrespondenceMap();
            if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
                newID = obj.getObjectID();
                result = this.storageDesign.getStorageObject(newID);
            }
        }
        return result;
    }

    @Override
    public String translateToString(Object object) {
        if (object != null) {
            return ((StorageObject)object).getObjectID();
        }
        return NO_OBJECT;
    }

    @Override
    public boolean canHandleClass(Class cls) {
        return this.storageObjectClass.isAssignableFrom(cls);
    }

    @Override
    public boolean isStatefull() {
        return true;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }
}

