/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.util.GUID;

public class SpatialColumnDefObject
implements ID_ObjectPropertyTranslator {
    private String name;
    private String objectID;
    private String funcExpression;
    private boolean function;
    private Column spatialColumn;
    private Index spatialIndex;
    private String systemID;
    private List spatialDimensions;
    private Table parent;
    private String spatialColumnName;
    private String spatialIndexName;

    public SpatialColumnDefObject(Table parent) {
        this.parent = parent;
        this.name = this.createName();
        this.objectID = new GUID().toString();
    }

    public void setSpatialColumn(Column specialColumn) {
        this.spatialColumn = specialColumn;
        if (this.spatialColumn != null && this.getSpatialIndex() != null) {
            this.getSpatialIndex().add(this.spatialColumn);
        }
    }

    public void setFuncExpression(String funcExpression) {
        this.funcExpression = funcExpression;
        if (this.getSpatialIndex() != null) {
            this.getSpatialIndex().setIndexExpression(funcExpression);
        }
    }

    public String getName() {
        return this.name;
    }

    private String createName() {
        return this.createName(this.parent.getSpatialDefinitions().size() + 1);
    }

    public String createName(int number) {
        return this.getObjectTypeName().concat("_").concat(String.valueOf(number));
    }

    public String getObjectTypeName() {
        return "ColumnDefinition";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    public String getFuncExpression() {
        return this.funcExpression;
    }

    public boolean isFunction() {
        return this.function;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }

    public Column getSpatialColumn() {
        return this.spatialColumn;
    }

    public Index getSpatialIndex() {
        return this.spatialIndex;
    }

    public void setSpatialIndex(Index spatialIndex) {
        if (this.spatialIndex != null && this.spatialIndex != spatialIndex) {
            this.spatialIndex.setSpatialColumnDefiniton(null);
        } else if (spatialIndex != null) {
            spatialIndex.setSpatialColumnDefiniton(this);
        }
        this.spatialIndex = spatialIndex;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    public TableDimension createTableDimension() {
        TableDimension tableDimension = new TableDimension();
        return tableDimension;
    }

    public List getTableDimensions() {
        if (this.spatialDimensions == null) {
            this.spatialDimensions = new ArrayList();
        }
        return this.spatialDimensions;
    }

    public void setTableDimensions(List tableDimensions) {
        this.getTableDimensions().clear();
        for (TableDimension td : tableDimensions) {
            if (td.isEmpty()) continue;
            this.addTableDimension(td);
        }
    }

    private void addTableDimension(TableDimension dimension) {
        this.getTableDimensions().add(dimension);
    }

    public String getSpatialColumnName() {
        if (this.spatialColumn != null) {
            return this.spatialColumn.getName();
        }
        return this.spatialColumnName;
    }

    public void setSpatialColumnName(String name) {
        Column column = null;
        if (name == null || name.isEmpty()) {
            this.spatialColumnName = null;
        } else {
            this.spatialColumnName = name;
            if (this.parent != null) {
                column = (Column)this.parent.getElementByName(name);
            }
        }
        this.setSpatialColumn(column);
    }

    public String getSpatialIndexName() {
        if (this.spatialIndex != null) {
            return this.spatialIndex.getName();
        }
        return this.spatialIndexName;
    }

    public void setSpatialIndexName(String name) {
        Index index = null;
        if (name == null || name.isEmpty()) {
            this.spatialIndexName = null;
        } else {
            this.spatialIndexName = name;
            if (this.parent != null) {
                for (Index anIndex : this.parent.getIndexes()) {
                    if (!anIndex.getName().equalsIgnoreCase(name) || !anIndex.getIndexState().endsWith("Plain Index")) continue;
                    index = anIndex;
                    break;
                }
            }
        }
        this.setSpatialIndex(index);
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        return this.parent.translateIdToObject(propertyName, id);
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        return this.parent.translateObjectToID(propertyName, object);
    }

    public void copyTo(SpatialColumnDefObject spColDef, Map map) {
        Index ind;
        Table t_table = spColDef.getParent();
        Column col = this.getSpatialColumn();
        if (col != null) {
            String id = col.getObjectID();
            Column t_col = (Column)t_table.getElementByID(id);
            if (t_col == null) {
                if (map != null) {
                    t_col = (Column)map.get(id);
                }
                if (t_col == null) {
                    t_col = (Column)t_table.getElementByName(col.getName());
                }
            }
            spColDef.setSpatialColumn(t_col);
        }
        if ((ind = this.getSpatialIndex()) != null) {
            String id = ind.getObjectID();
            Index t_ind = (Index)t_table.getKeySet().getObjectByID(id);
            if (t_ind == null) {
                if (map != null) {
                    t_ind = (Index)map.get(id);
                }
                if (t_ind == null) {
                    t_ind = (Index)t_table.getKeySet().getByName(ind.getName());
                }
            }
            if (t_ind != null) {
                spColDef.setSpatialIndex(t_ind);
            }
        }
        spColDef.setSystemID(this.getSystemID());
        spColDef.setFuncExpression(this.getFuncExpression());
        spColDef.setFunction(this.isFunction());
        spColDef.setName(this.getName());
        this.copyDimensionsTo(spColDef);
    }

    public void copyTo(SpatialColumnDefObject spColDef) {
        this.copyTo(spColDef, null);
    }

    private void copyDimensionsTo(SpatialColumnDefObject spColDef) {
        for (TableDimension dim : this.getTableDimensions()) {
            TableDimension t_dim = spColDef.new TableDimension();
            dim.copyTo(t_dim);
        }
    }

    public Table getParent() {
        return this.parent;
    }

    public class TableDimension {
        private String name = "";
        private String lowBoundary = "";
        private String upperBoundary = "";
        private String tolerance = "";
        private String dimensionID = new GUID().toString();
        private Table parent;

        public TableDimension() {
            SpatialColumnDefObject.this.addTableDimension(this);
        }

        public String getLowBoundary() {
            return this.lowBoundary;
        }

        public void setLowBoundary(String lowBoundary) {
            this.lowBoundary = lowBoundary;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTolerance() {
            return this.tolerance;
        }

        public void setTolerance(String tolerance) {
            this.tolerance = tolerance;
        }

        public String getUpperBoundary() {
            return this.upperBoundary;
        }

        public void setUpperBoundary(String upperBoundary) {
            this.upperBoundary = upperBoundary;
        }

        public boolean isEmpty() {
            return this.name.trim().equals("") || this.lowBoundary.trim().equals("") || this.upperBoundary.trim().equals("") || this.tolerance.trim().equals("");
        }

        public void copyTo(TableDimension targetDim) {
            targetDim.setName(this.getName());
            targetDim.setLowBoundary(this.getLowBoundary());
            targetDim.setUpperBoundary(this.getUpperBoundary());
            targetDim.setTolerance(this.getTolerance());
        }

        public String getDimensionID() {
            return this.dimensionID;
        }

        public void setDimensionID(String dimensionID) {
            this.dimensionID = dimensionID;
        }
    }
}

