/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class InheritanceRelationSet
extends RelationSet {
    public static final Object[] PROTOTYPE_ARRAY = new InheritanceRelation[0];
    private IDGenerator pseudoGenerator = new IDGenerator();

    public InheritanceRelationSet(DesignPart designPart) {
        super(designPart);
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default inheritance relation name");
    }

    @Override
    public Relation createRelation(String oldID) {
        if (this.getDesign().isLoading()) {
            InheritanceRelation relation = new InheritanceRelation(this.getDesignPart());
            relation.setObjectID(oldID);
            relation.setDesign(this.getDesign());
            relation.setDesignObjectSet(this);
            this.getDesign().addDesignObject(relation);
            this.add(relation);
            relation.setNameOnTarget("Sub Type");
            relation.setNameOnSource("Super Type");
            return relation;
        }
        throw new IllegalArgumentException("InheritanceRelations should be created using createRelation(String, Entity, Entity)");
    }

    public InheritanceRelation createInheritanceRelation() {
        InheritanceRelation relation = new InheritanceRelation(this.getDesignPart());
        relation.setDesign(this.getDesign());
        relation.setDesignObjectSet(this);
        this.getDesign().addDesignObject(relation);
        this.add(relation);
        relation.setNameOnTarget("Sub Type");
        relation.setNameOnSource("Super Type");
        return relation;
    }

    public Relation createRelation(String oldID, Entity parent, Entity child) {
        InheritanceRelation relation = new InheritanceRelation(this.getDesignPart());
        relation.setObjectID(oldID);
        relation.setDesign(this.getDesign());
        relation.setDesignObjectSet(this);
        this.getDesign().addDesignObject(relation);
        this.add(relation);
        ((Relation)relation).setTargetEntity(child);
        ((Relation)relation).setSourceEntity(parent);
        relation.setNameOnTarget("Sub Type");
        relation.setNameOnSource("Super Type");
        ((TVRelation)relation.getTopView()).addConnection();
        relation.setSourceTV(relation.getSourceTVEntity());
        relation.setTargetTV(relation.getTargetTVEntity());
        return relation;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTOTYPE_ARRAY;
    }

    public IDGenerator getPseudoGenerator() {
        return this.pseudoGenerator;
    }

    public InheritanceRelation getInheritanceRelation(Entity parent, Entity child) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            InheritanceRelation rel = (InheritanceRelation)it.next();
            if (rel.getSourceEntity() != parent || rel.getTargetEntity() != child) continue;
            return rel;
        }
        return null;
    }

    public InheritanceRelation getInheritanceRelationFor(Entity ent1, Entity ent2) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            InheritanceRelation rel = (InheritanceRelation)it.next();
            if ((rel.getSourceEntity() != ent1 || rel.getTargetEntity() != ent2) && (rel.getSourceEntity() != ent2 || rel.getTargetEntity() != ent1)) continue;
            return rel;
        }
        return null;
    }

    public List getSubtypesOf(Entity parent) {
        ArrayList<InheritanceRelation> list = new ArrayList<InheritanceRelation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            InheritanceRelation rel = (InheritanceRelation)it.next();
            if (rel.getSourceEntity() != parent) continue;
            list.add(rel);
        }
        return list;
    }
}

