/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;

public class CSSBDropTableConstraint
extends AbstractCSSBOracle {
    protected StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object == null) {
            return;
        }
        ModelIDObject modelObject = ((CompareObjectSelection)object).getCorrespondentNode().getObject();
        if (modelObject instanceof TableLevelConstraint) {
            TableCheckConstraintOracle tcco;
            TableLevelConstraint tableConstraint;
            ModelIDObject objToDelete = tableConstraint = (TableLevelConstraint)modelObject;
            Table table = tableConstraint.getTable();
            Design design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            if (tableProxy instanceof TableProxyOracle && (tcco = ((TableProxyOracle)tableProxy).getTableConstraint(tableConstraint)) != null) {
                objToDelete = tcco;
            }
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            StringBuffer buffer = new StringBuffer();
            CSSBDropTableConstraint.appendStringWithSpace(buffer, "ALTER");
            CSSBDropTableConstraint.appendStringWithSpace(buffer, "TABLE");
            CSSBDropTableConstraint.appendStringWithSpace(buffer, this.getTableName((CompareObjectSelection)object));
            CSSBDropTableConstraint.appendStringWithSpace(buffer, "DROP");
            CSSBDropTableConstraint.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBDropTableConstraint.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(objToDelete));
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBDropTableConstraint.appendNewLine(buffer, prettyPrint, 0);
            CSSBDropTableConstraint.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterTable();
            this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof TableLevelConstraint;
    }

    protected String getTableName(CompareObjectSelection constraint) {
        CompareObjectSelection table = constraint.getTableNode();
        if (table != null) {
            return CSSBDropTableConstraint.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }
}

