/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.io.IOException;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.undo.relational.memento.Memento;

public abstract class KeyObject
extends SubsetCO
implements Constants {
    protected boolean unique = false;
    private FKIndexAssociation fkassociation = null;
    private boolean oidKey = false;
    private transient boolean isPK_temp = false;

    public KeyObject(DesignPart designPart) {
        super(designPart);
    }

    public abstract boolean isSurrogateKey();

    public abstract ContainedObject[] getColumns();

    public abstract Memento getIndexMemento();

    public abstract void synchronizeMarkedGenerate(boolean var1);

    public abstract String getColumnSortOrder(Object var1);

    public abstract String getIndexState();

    public abstract void setColumnSortOrder(Object var1, String var2);

    public boolean isValidPK() {
        ContainedObject[] elements = this.getElements();
        if (elements.length == 0) {
            return false;
        }
        boolean result = true;
        return result;
    }

    public void makeValidPKIfNotEmpty() {
        ContainedObject[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            elements[i].setNullsAllowed(false);
        }
    }

    public void setUnique(boolean unique) {
        if (this.unique != unique) {
            this.unique = unique;
            this.isPK_temp = false;
            this.setColumnsState(unique);
            ObjectChangeEvent event = null;
            event = unique ? ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE : ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE;
            if (!this.backup) {
                this.fireChange(event);
            }
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void makePK() {
        this.setPK(true);
        this.makeValidPKIfNotEmpty();
    }

    public void setColumnsState(boolean value) {
        ContainedObject[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].isUnique() == value) continue;
            elements[i].setUnique(value);
        }
    }

    public void setPK(boolean value) {
        boolean waspk = this.isPK();
        if (!waspk && !value) {
            return;
        }
        if (waspk == value) {
            if (value) {
                ((ContainerWithKeyObject)this.getTopLevelContainer()).setPK(this);
            }
            return;
        }
        if (value && this.isUnique()) {
            this.setUnique(false);
        }
        if (this.getTopLevelContainer() != null) {
            KeyObject key = value ? this : null;
            KeyObject oldkey = ((ContainerWithKeyObject)this.getTopLevelContainer()).getPK();
            ObjectChangeEvent event = null;
            boolean belongsToContainer = ((ContainerWithKeyObject)this.getTopLevelContainer()).hasKey(this);
            if (value) {
                if (oldkey != null && oldkey != key && value) {
                    oldkey.firePKRemoved();
                    oldkey.isPK_temp = false;
                }
                if (belongsToContainer) {
                    ((ContainerWithKeyObject)this.getTopLevelContainer()).setPK(key);
                    this.isPK_temp = true;
                    this.makeValidPKIfNotEmpty();
                    event = ObjectChangeEvent.KEY_CHANGED_TO_PK;
                } else {
                    this.isPK_temp = true;
                    this.makeValidPKIfNotEmpty();
                }
            } else {
                this.isPK_temp = false;
                if (waspk && belongsToContainer) {
                    ((ContainerWithKeyObject)this.getTopLevelContainer()).setPK(null);
                }
                event = ObjectChangeEvent.KEY_CHANGED_NO_PK;
            }
            if (event != null && !this.backup) {
                this.fireChange(event);
            }
            if (!value && !this.isUnique()) {
                this.setUnique(true);
            }
        }
    }

    public void firePKRemoved() {
        ObjectChangeEvent event = ObjectChangeEvent.PK_REMOVED;
        this.fireChange(event);
        this.setUnique(true);
    }

    public boolean isPK() {
        if (this.getTopLevelContainer() != null) {
            if (this.isPK_temp) {
                return true;
            }
            ContainerWithKeyObject cont = (ContainerWithKeyObject)this.getTopLevelContainer();
            KeyObject pkey = cont.getPK();
            if (pkey != null && cont.hasKey(this)) {
                if (this == pkey) {
                    return true;
                }
                String pkObjectID = pkey.getObjectID();
                if (pkObjectID != null && pkObjectID.equals(this.getObjectID())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFK() {
        return this.getFKAssociation() != null;
    }

    public FKIndexAssociation getFKAssociation() {
        return this.fkassociation;
    }

    public void setFKAssociation(FKIndexAssociation fkassociation) {
        this.fkassociation = fkassociation;
    }

    @Override
    public void remove() {
        super.remove();
        if (this.getContainerWithKeyObject() != null) {
            this.getContainerWithKeyObject().remove(this);
        }
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return (ContainerWithKeyObject)this.getTopLevelContainer();
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public boolean isOidKey() {
        return this.oidKey;
    }

    public void setOidKey(boolean oidKey) {
        this.oidKey = oidKey;
    }

    @Override
    protected void assignLocalID(ModelIDObject object) {
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty && this.getContainerObject() != null) {
            this.getContainerObject().setDirty(dirty);
        }
    }

    @Override
    public void copy(DesignObject desObject) throws IOException {
        super.copy(desObject);
        KeyObject key = (KeyObject)desObject;
        this.setOidKey(this.isOidKey());
        ContainerWithKeyObject cont = key.getContainerWithKeyObject();
        key.getElementsCollection().clear();
        for (ContainedObject co : this.getElementsCollection()) {
            ContainedObject co_new = cont.getElementByID(co.getObjectID());
            if (co_new == null) {
                co_new = cont.getElementByName(co.getName());
            }
            if (co_new == null) continue;
            key.add(co_new);
        }
    }

    @Override
    public void setObjectID(String id) {
        String oldID = this.getObjectID();
        super.setObjectID(id);
        ContainerWithKeyObject container = this.getContainerWithKeyObject();
        if (container != null && oldID == null) {
            container.putInLocalIDMap(id, this);
        }
        if (container != null && id != null && oldID != null && !id.equals(oldID)) {
            container.updateLocalObjectId(oldID, id);
        }
    }

    public String getColumnsAsString(StorageDesign storageDesign) {
        ContainedObject[] columns = this.getColumns();
        StringBuffer result = new StringBuffer();
        boolean b = false;
        for (int i = 0; i < columns.length; ++i) {
            if (b) {
                result.append(", ");
            } else {
                b = true;
            }
            String name = storageDesign.getFormatedName(columns[i]);
            result.append(name);
        }
        return result.toString();
    }

    public void setIndexState(String indexState) {
    }

    public String getIndexExpression() {
        return "";
    }

    public void setIndexExpression(String indexExpression) {
    }
}

